/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayDeque;
import java.util.Deque;

public class PathParameterAttribute
implements ExchangeAttribute {
    private final String parameter;

    public PathParameterAttribute(String parameter) {
        this.parameter = parameter;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        Deque<String> res = exchange.getPathParameters().get(this.parameter);
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return "";
        }
        if (res.size() == 1) {
            return res.getFirst();
        }
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        for (String s : res) {
            sb.append(s);
            if (++i == res.size()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        ArrayDeque<String> value = new ArrayDeque<String>();
        value.add(newValue);
        exchange.getPathParameters().put(this.parameter, value);
    }

    public String toString() {
        return "%{p," + this.parameter + "}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Path Parameter";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{p,") && token.endsWith("}")) {
                String qp = token.substring(4, token.length() - 1);
                return new PathParameterAttribute(qp);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

