package io.undertow.util;

/**
 * @author Stuart Douglas
 */
public class NetworkUtils {

    public static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }

    private NetworkUtils() {

    }
}
