/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.AllowedContentEncodings;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.ETagUtils;
import io.undertow.util.Headers;
import java.util.Date;

public class CachedHttpRequest {
    private final String path;
    private final ETag etag;
    private final String contentEncoding;
    private final String contentLocation;
    private final String language;
    private final String contentType;
    private final Date lastModified;
    private final int responseCode;

    public CachedHttpRequest(HttpServerExchange exchange) {
        this.path = exchange.getRequestPath();
        this.etag = ETagUtils.getETag(exchange);
        this.contentLocation = exchange.getResponseHeaders().getFirst(Headers.CONTENT_LOCATION);
        this.language = exchange.getResponseHeaders().getFirst(Headers.CONTENT_LANGUAGE);
        this.contentType = exchange.getResponseHeaders().getFirst(Headers.CONTENT_TYPE);
        String lmString = exchange.getResponseHeaders().getFirst(Headers.LAST_MODIFIED);
        this.lastModified = lmString == null ? null : DateUtils.parseDate(lmString);
        AllowedContentEncodings encoding = exchange.getAttachment(AllowedContentEncodings.ATTACHMENT_KEY);
        this.contentEncoding = encoding != null ? encoding.getCurrentContentEncoding() : exchange.getResponseHeaders().getFirst(Headers.CONTENT_ENCODING);
        this.responseCode = exchange.getResponseCode();
    }

    public String getPath() {
        return this.path;
    }

    public ETag getEtag() {
        return this.etag;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedHttpRequest that = (CachedHttpRequest)o;
        if (this.responseCode != that.responseCode) {
            return false;
        }
        if (this.contentEncoding != null ? !this.contentEncoding.equals(that.contentEncoding) : that.contentEncoding != null) {
            return false;
        }
        if (this.contentLocation != null ? !this.contentLocation.equals(that.contentLocation) : that.contentLocation != null) {
            return false;
        }
        if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) {
            return false;
        }
        if (this.etag != null ? !this.etag.equals(that.etag) : that.etag != null) {
            return false;
        }
        if (this.language != null ? !this.language.equals(that.language) : that.language != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.etag != null ? this.etag.hashCode() : 0);
        result = 31 * result + (this.contentEncoding != null ? this.contentEncoding.hashCode() : 0);
        result = 31 * result + (this.contentLocation != null ? this.contentLocation.hashCode() : 0);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        result = 31 * result + (this.lastModified != null ? this.lastModified.hashCode() : 0);
        result = 31 * result + this.responseCode;
        return result;
    }
}

