/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.LRUCache;
import io.undertow.server.handlers.resource.CachedResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.IOException;

public class CachingResourceManager
implements ResourceManager {
    private final long maxFileSize;
    private final ResourceManager underlyingResourceManager;
    private final DirectBufferCache dataCache;
    private final LRUCache<String, Object> cache;
    private final int maxAge;

    public CachingResourceManager(int metadataCacheSize, long maxFileSize, DirectBufferCache dataCache, ResourceManager underlyingResourceManager, int maxAge) {
        this.maxFileSize = maxFileSize;
        this.underlyingResourceManager = underlyingResourceManager;
        this.dataCache = dataCache;
        this.cache = new LRUCache(metadataCacheSize, maxAge);
        this.maxAge = maxAge;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Resource getResource(String path) throws IOException {
        Resource underlying;
        Object res = this.cache.get(path);
        if (res instanceof NoResourceMarker) {
            NoResourceMarker marker = (NoResourceMarker)res;
            long nextCheck = marker.getNextCheckTime();
            if (nextCheck <= 0L) return null;
            long time = System.currentTimeMillis();
            if (time <= nextCheck) return null;
            marker.setNextCheckTime(time + (long)this.maxAge);
            if (this.underlyingResourceManager.getResource(path) == null) return null;
            this.cache.remove(path);
        } else if (res != null) {
            CachedResource resource = (CachedResource)res;
            if (resource.checkStillValid()) {
                return (Resource)res;
            }
            this.invalidate(path);
        }
        if ((underlying = this.underlyingResourceManager.getResource(path)) == null) {
            this.cache.add(path, new NoResourceMarker(this.maxAge > 0 ? System.currentTimeMillis() + (long)this.maxAge : -1L));
            return null;
        }
        CachedResource resource = new CachedResource(this, underlying, path);
        this.cache.add(path, resource);
        return resource;
    }

    public void invalidate(String path) {
        try {
            CachedResource resource = (CachedResource)this.getResource(path);
            if (resource != null) {
                resource.invalidate();
            }
        }
        catch (IOException e) {
            UndertowLogger.ROOT_LOGGER.debugf(e, "Exception invalidating cached resource %s", path);
        }
        this.cache.remove(path);
    }

    DirectBufferCache getDataCache() {
        return this.dataCache;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    private static final class NoResourceMarker {
        volatile long nextCheckTime;

        private NoResourceMarker(long nextCheckTime) {
            this.nextCheckTime = nextCheckTime;
        }

        public long getNextCheckTime() {
            return this.nextCheckTime;
        }

        public void setNextCheckTime(long nextCheckTime) {
            this.nextCheckTime = nextCheckTime;
        }
    }
}

