/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

class PathMatchPredicate
implements Predicate {
    private final String slashPath;
    private final String path;

    public PathMatchPredicate(String path) {
        if (path.startsWith("/")) {
            this.slashPath = path;
            this.path = path.substring(1);
        } else {
            this.slashPath = "/" + path;
            this.path = path;
        }
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String relativePath = value.getRelativePath();
        if (relativePath.startsWith("/")) {
            return relativePath.equals(this.slashPath);
        }
        return relativePath.equals(this.path);
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "path";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("path", String.class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("path");
        }

        @Override
        public String defaultParameter() {
            return "path";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String path = (String)config.get("path");
            return new PathMatchPredicate(path);
        }
    }
}

