/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpHandlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.Headers;
import java.util.Map;

public class NameVirtualHostHandler
implements HttpHandler {
    private volatile HttpHandler defaultHandler = ResponseCodeHandler.HANDLE_404;
    private final Map<String, HttpHandler> hosts = new CopyOnWriteMap<String, HttpHandler>();

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String host;
        HttpHandler handler;
        String hostHeader = exchange.getRequestHeaders().getFirst(Headers.HOST);
        if (hostHeader != null && (handler = this.hosts.get(host = hostHeader.contains(":") ? hostHeader.substring(0, hostHeader.indexOf(":")) : hostHeader)) != null) {
            handler.handleRequest(exchange);
            return;
        }
        this.defaultHandler.handleRequest(exchange);
    }

    public HttpHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public Map<String, HttpHandler> getHosts() {
        return this.hosts;
    }

    public NameVirtualHostHandler setDefaultHandler(HttpHandler defaultHandler) {
        HttpHandlers.handlerNotNull(defaultHandler);
        this.defaultHandler = defaultHandler;
        return this;
    }

    public synchronized NameVirtualHostHandler addHost(String host, HttpHandler handler) {
        HttpHandlers.handlerNotNull(handler);
        this.hosts.put(host, handler);
        return this;
    }

    public synchronized NameVirtualHostHandler removeHost(String host) {
        this.hosts.remove(host);
        return this;
    }
}

