/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.ETagUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import javax.servlet.DispatcherType;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultServlet
extends HttpServlet {
    private Deployment deployment;
    private DefaultServletConfig config;
    private ResourceManager resourceManager;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContextImpl sc = (ServletContextImpl)config.getServletContext();
        this.deployment = sc.getDeployment();
        DefaultServletConfig defaultServletConfig = this.deployment.getDeploymentInfo().getDefaultServletConfig();
        this.config = defaultServletConfig != null ? defaultServletConfig : new DefaultServletConfig();
        this.resourceManager = this.deployment.getDeploymentInfo().getResourceManager();
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getPath(req);
        if (!this.isAllowed(path)) {
            resp.sendError(404);
            return;
        }
        Resource resource = this.resourceManager.getResource(path);
        if (resource == null) {
            if (req.getDispatcherType() == DispatcherType.INCLUDE) {
                throw new FileNotFoundException(path);
            }
            resp.sendError(404);
            return;
        }
        if (resource.isDirectory()) {
            resp.sendError(404);
        } else {
            this.serveFileBlocking(req, resp, resource);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        switch (req.getDispatcherType()) {
            case INCLUDE: 
            case FORWARD: {
                this.doGet(req, resp);
                break;
            }
            default: {
                super.doPost(req, resp);
            }
        }
    }

    private void serveFileBlocking(HttpServletRequest req, HttpServletResponse resp, Resource resource) throws IOException {
        boolean include;
        ETag etag = resource.getETag();
        Date lastModified = resource.getLastModified();
        if (!ETagUtils.handleIfMatch(req.getHeader("If-Match"), etag, false) || !DateUtils.handleIfUnmodifiedSince(req.getHeader("If-Unmodified-Since"), lastModified)) {
            resp.setStatus(412);
            return;
        }
        if (!ETagUtils.handleIfNoneMatch(req.getHeader("If-None-Match"), etag, true) || !DateUtils.handleIfModifiedSince(req.getHeader("If-Modified-Since"), lastModified)) {
            resp.setStatus(304);
            return;
        }
        String contentType = this.deployment.getServletContext().getMimeType(resource.getName());
        if (contentType != null) {
            resp.setHeader("Content-Type", contentType);
        } else {
            resp.setHeader("Content-Type", "application/octet-stream");
        }
        if (lastModified != null) {
            resp.setHeader("Last-Modified", resource.getLastModifiedString());
        }
        if (etag != null) {
            resp.setHeader("ETag", etag.toString());
        }
        try {
            Long contentLength = resource.getContentLength();
            if (contentLength != null) {
                resp.getOutputStream();
                resp.setContentLengthLong(contentLength);
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        boolean bl = include = req.getDispatcherType() == DispatcherType.INCLUDE;
        if (!req.getMethod().equals("HEAD")) {
            HttpServerExchange exchange = ServletRequestContext.requireCurrent().getOriginalRequest().getExchange();
            resource.serve(exchange.getResponseSender(), exchange, new IoCallback(){

                @Override
                public void onComplete(HttpServerExchange exchange, Sender sender) {
                    if (!include) {
                        sender.close();
                    }
                }

                @Override
                public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                    sender.close();
                }
            });
        }
    }

    private String getPath(HttpServletRequest request) {
        if (request.getDispatcherType() == DispatcherType.INCLUDE && request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null) {
                result = (String)request.getAttribute("javax.servlet.include.servlet_path");
            }
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        String result = request.getPathInfo();
        if (result == null) {
            result = request.getServletPath();
        }
        if (result == null || result.equals("")) {
            result = "/";
        }
        return result;
    }

    private boolean isAllowed(String path) {
        if (!path.isEmpty() && (path.startsWith("/META-INF") || path.startsWith("META-INF") || path.startsWith("/WEB-INF") || path.startsWith("WEB-INF"))) {
            return false;
        }
        int pos = path.lastIndexOf(47);
        String lastSegment = pos == -1 ? path : path.substring(pos + 1);
        if (lastSegment.isEmpty()) {
            return true;
        }
        int ext = lastSegment.lastIndexOf(46);
        if (ext == -1) {
            return true;
        }
        String extension = lastSegment.substring(ext + 1, lastSegment.length());
        if (this.config.isDefaultAllowed()) {
            return !this.config.getDisallowed().contains(extension);
        }
        return this.config.getAllowed().contains(extension);
    }
}

