/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.server.HttpServerExchange;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Deque;
import java.util.Map;

public class RedirectBuilder {
    public static final String UTF_8 = "UTF-8";

    public static String redirect(HttpServerExchange exchange, String newRelativePath) {
        try {
            StringBuilder uri = new StringBuilder(exchange.getRequestScheme());
            uri.append("://");
            uri.append(exchange.getHostAndPort());
            uri.append(URLEncoder.encode(exchange.getResolvedPath(), UTF_8));
            if (exchange.getResolvedPath().endsWith("/")) {
                if (newRelativePath.startsWith("/")) {
                    uri.append(URLEncoder.encode(newRelativePath.substring(1), UTF_8));
                } else {
                    uri.append(URLEncoder.encode(newRelativePath, UTF_8));
                }
            } else {
                if (!newRelativePath.startsWith("/")) {
                    uri.append('/');
                }
                uri.append(URLEncoder.encode(newRelativePath, UTF_8));
            }
            if (!exchange.getPathParameters().isEmpty()) {
                boolean first = true;
                uri.append(';');
                for (Map.Entry param : exchange.getPathParameters().entrySet()) {
                    for (String value : (Deque)param.getValue()) {
                        if (first) {
                            first = false;
                        } else {
                            uri.append('&');
                        }
                        uri.append(URLEncoder.encode((String)param.getKey(), UTF_8));
                        uri.append('=');
                        uri.append(URLEncoder.encode(value, UTF_8));
                    }
                }
            }
            if (!exchange.getQueryString().isEmpty()) {
                uri.append('?');
                uri.append(exchange.getQueryString());
            }
            return uri.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private RedirectBuilder() {
    }
}

