/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.ClosedWorkerException;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.MulticastMessageChannel;
import org.xnio.nio.Log;
import org.xnio.nio.NioTcpServer;
import org.xnio.nio.NioUdpChannel;
import org.xnio.nio.NioXnio;
import org.xnio.nio.WorkerThread;

final class NioXnioWorker
extends XnioWorker {
    private static final int CLOSE_REQ = Integer.MIN_VALUE;
    private static final int CLOSE_COMP = 0x40000000;
    private volatile int state = 1;
    private final WorkerThread[] workerThreads;
    private volatile Thread shutdownWaiter;
    private static final AtomicReferenceFieldUpdater<NioXnioWorker, Thread> shutdownWaiterUpdater = AtomicReferenceFieldUpdater.newUpdater(NioXnioWorker.class, Thread.class, "shutdownWaiter");
    private static final AtomicIntegerFieldUpdater<NioXnioWorker> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(NioXnioWorker.class, "state");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NioXnioWorker(NioXnio xnio, ThreadGroup threadGroup, OptionMap optionMap, Runnable terminationTask) throws IOException {
        super((Xnio)xnio, threadGroup, optionMap, terminationTask);
        int threadCount = optionMap.contains(Options.WORKER_IO_THREADS) ? optionMap.get(Options.WORKER_IO_THREADS, 0) : Math.max(optionMap.get(Options.WORKER_READ_THREADS, 1), optionMap.get(Options.WORKER_WRITE_THREADS, 1));
        if (threadCount < 0) {
            throw Log.log.optionOutOfRange("WORKER_IO_THREADS");
        }
        long workerStackSize = optionMap.get(Options.STACK_SIZE, 0L);
        if (workerStackSize < 0L) {
            throw Log.log.optionOutOfRange("STACK_SIZE");
        }
        String workerName = this.getName();
        WorkerThread[] workerThreads = new WorkerThread[threadCount];
        boolean markWorkerThreadAsDaemon = optionMap.get(Options.THREAD_DAEMON, false);
        boolean ok = false;
        try {
            for (int i = 0; i < threadCount; ++i) {
                WorkerThread workerThread = new WorkerThread(this, xnio.mainSelectorCreator.open(), String.format("%s I/O-%d", workerName, i + 1), threadGroup, workerStackSize, i);
                if (markWorkerThreadAsDaemon) {
                    workerThread.setDaemon(true);
                }
                workerThreads[i] = workerThread;
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (WorkerThread worker : workerThreads) {
                    if (worker == null) continue;
                    IoUtils.safeClose((Selector)worker.getSelector());
                }
            }
        }
        this.workerThreads = workerThreads;
    }

    void start() {
        for (WorkerThread worker : this.workerThreads) {
            this.openResourceUnconditionally();
            worker.start();
        }
    }

    protected WorkerThread chooseThread() {
        WorkerThread[] workerThreads = this.workerThreads;
        int length = workerThreads.length;
        if (length == 0) {
            throw Log.log.noThreads();
        }
        if (length == 1) {
            return workerThreads[0];
        }
        Random random = IoUtils.getThreadLocalRandom();
        return workerThreads[random.nextInt(length)];
    }

    public int getIoThreadCount() {
        return this.workerThreads.length;
    }

    WorkerThread[] getAll() {
        return this.workerThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AcceptingChannel<StreamConnection> createTcpConnectionServer(InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<StreamConnection>> acceptListener, OptionMap optionMap) throws IOException {
        this.checkShutdown();
        boolean ok = false;
        ServerSocketChannel channel = ServerSocketChannel.open();
        try {
            if (optionMap.contains(Options.RECEIVE_BUFFER)) {
                channel.socket().setReceiveBufferSize(optionMap.get(Options.RECEIVE_BUFFER, -1));
            }
            channel.socket().setReuseAddress(optionMap.get(Options.REUSE_ADDRESSES, true));
            channel.configureBlocking(false);
            if (optionMap.contains(Options.BACKLOG)) {
                channel.socket().bind(bindAddress, optionMap.get(Options.BACKLOG, 128));
            } else {
                channel.socket().bind(bindAddress);
            }
            NioTcpServer server = new NioTcpServer(this, channel, optionMap);
            server.setAcceptListener(acceptListener);
            ok = true;
            NioTcpServer nioTcpServer = server;
            return nioTcpServer;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }

    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        this.checkShutdown();
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        if (optionMap.contains(Options.BROADCAST)) {
            channel.socket().setBroadcast(optionMap.get(Options.BROADCAST, false));
        }
        if (optionMap.contains(Options.IP_TRAFFIC_CLASS)) {
            channel.socket().setTrafficClass(optionMap.get(Options.IP_TRAFFIC_CLASS, -1));
        }
        if (optionMap.contains(Options.RECEIVE_BUFFER)) {
            channel.socket().setReceiveBufferSize(optionMap.get(Options.RECEIVE_BUFFER, -1));
        }
        channel.socket().setReuseAddress(optionMap.get(Options.REUSE_ADDRESSES, true));
        if (optionMap.contains(Options.SEND_BUFFER)) {
            channel.socket().setSendBufferSize(optionMap.get(Options.SEND_BUFFER, -1));
        }
        channel.socket().bind(bindAddress);
        NioUdpChannel udpChannel = new NioUdpChannel(this, channel);
        ChannelListeners.invokeChannelListener((Channel)((Object)udpChannel), bindListener);
        return udpChannel;
    }

    public boolean isShutdown() {
        return (this.state & Integer.MIN_VALUE) != 0;
    }

    public boolean isTerminated() {
        return (this.state & 0x40000000) != 0;
    }

    void openResourceUnconditionally() {
        int oldState = stateUpdater.getAndIncrement(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, oldState, oldState + 1);
        }
    }

    void checkShutdown() throws ClosedWorkerException {
        if (this.isShutdown()) {
            throw Log.log.workerShutDown();
        }
    }

    void closeResource() {
        int oldState = stateUpdater.decrementAndGet(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, oldState + 1, oldState);
        }
        while (oldState == Integer.MIN_VALUE) {
            if (stateUpdater.compareAndSet(this, Integer.MIN_VALUE, -1073741824)) {
                Log.log.tracef("CAS %s %08x -> %08x (close complete)", (Object)this, Integer.MIN_VALUE, -1073741824);
                NioXnioWorker.safeUnpark(shutdownWaiterUpdater.getAndSet(this, null));
                Runnable task = this.getTerminationTask();
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return;
            }
            oldState = this.state;
        }
    }

    public void shutdown() {
        int oldState = this.state;
        while ((oldState & Integer.MIN_VALUE) == 0) {
            if (!stateUpdater.compareAndSet(this, oldState, oldState | Integer.MIN_VALUE)) {
                oldState = this.state;
                continue;
            }
            Log.log.tracef("Initiating shutdown of %s", (Object)this);
            for (WorkerThread worker : this.workerThreads) {
                worker.shutdown();
            }
            this.shutDownTaskPool();
            return;
        }
        Log.log.tracef("Idempotent shutdown of %s", (Object)this);
    }

    public List<Runnable> shutdownNow() {
        this.shutdown();
        return this.shutDownTaskPoolNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        int oldState = this.state;
        if (Bits.allAreSet((int)oldState, (int)0x40000000)) {
            return true;
        }
        long then = System.nanoTime();
        long duration = unit.toNanos(timeout);
        Thread myThread = Thread.currentThread();
        while (Bits.allAreClear((int)(oldState = this.state), (int)0x40000000)) {
            Thread oldThread = shutdownWaiterUpdater.getAndSet(this, myThread);
            try {
                oldState = this.state;
                if (Bits.allAreSet((int)oldState, (int)0x40000000)) break;
                LockSupport.parkNanos((Object)this, duration);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                long now = System.nanoTime();
                if ((duration -= now - then) >= 0L) continue;
                oldState = this.state;
                break;
            }
            finally {
                NioXnioWorker.safeUnpark(oldThread);
            }
        }
        return Bits.allAreSet((int)oldState, (int)0x40000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitTermination() throws InterruptedException {
        int oldState = this.state;
        if (Bits.allAreSet((int)oldState, (int)0x40000000)) {
            return;
        }
        Thread myThread = Thread.currentThread();
        while (Bits.allAreClear((int)this.state, (int)0x40000000)) {
            Thread oldThread = shutdownWaiterUpdater.getAndSet(this, myThread);
            try {
                if (!Bits.allAreSet((int)this.state, (int)0x40000000)) {
                    LockSupport.park((Object)this);
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
                break;
            }
            finally {
                NioXnioWorker.safeUnpark(oldThread);
            }
        }
    }

    private static void safeUnpark(Thread waiter) {
        if (waiter != null) {
            LockSupport.unpark(waiter);
        }
    }

    protected void taskPoolTerminated() {
        this.closeResource();
    }

    public NioXnio getXnio() {
        return (NioXnio)super.getXnio();
    }
}

