/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import io.undertow.UndertowMessages;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class DetachableStreamSourceChannel
implements StreamSourceChannel {
    protected final StreamSourceChannel delegate;
    protected final ChannelListener.SimpleSetter<DetachableStreamSourceChannel> readSetter = new ChannelListener.SimpleSetter();
    protected final ChannelListener.SimpleSetter<DetachableStreamSourceChannel> closeSetter = new ChannelListener.SimpleSetter();

    public DetachableStreamSourceChannel(StreamSourceChannel delegate) {
        this.delegate = delegate;
        delegate.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

            @Override
            public void handleEvent(StreamSourceChannel channel) {
                if (DetachableStreamSourceChannel.this.isFinished()) {
                    channel.suspendReads();
                    return;
                }
                ChannelListener<DetachableStreamSourceChannel> listener = DetachableStreamSourceChannel.this.readSetter.get();
                if (listener == null) {
                    channel.suspendReads();
                    return;
                }
                listener.handleEvent(DetachableStreamSourceChannel.this);
            }
        });
        delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener(this, this.closeSetter));
    }

    protected abstract boolean isFinished();

    @Override
    public void resumeReads() {
        if (this.isFinished()) {
            return;
        }
        this.delegate.resumeReads();
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        if (this.isFinished()) {
            return -1L;
        }
        return this.delegate.transferTo(position, count, target);
    }

    @Override
    public void awaitReadable() throws IOException {
        if (this.isFinished()) {
            return;
        }
        this.delegate.awaitReadable();
    }

    @Override
    public void suspendReads() {
        if (this.isFinished()) {
            return;
        }
        this.delegate.suspendReads();
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        if (this.isFinished()) {
            return -1L;
        }
        return this.delegate.transferTo(count, throughBuffer, target);
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public boolean isReadResumed() {
        if (this.isFinished()) {
            return false;
        }
        return this.delegate.isReadResumed();
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        return this.delegate.setOption(option, value);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.delegate.supportsOption(option);
    }

    @Override
    public void shutdownReads() throws IOException {
        if (this.isFinished()) {
            return;
        }
        this.delegate.shutdownReads();
    }

    @Override
    public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
        return this.readSetter;
    }

    @Override
    public boolean isOpen() {
        if (this.isFinished()) {
            return false;
        }
        return this.delegate.isOpen();
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        if (this.isFinished()) {
            return -1L;
        }
        return this.delegate.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.isFinished()) {
            return -1L;
        }
        return this.delegate.read(dsts, offset, length);
    }

    @Override
    public void wakeupReads() {
        if (this.isFinished()) {
            return;
        }
        this.delegate.wakeupReads();
    }

    @Override
    public XnioExecutor getReadThread() {
        return this.delegate.getReadThread();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.channelIsClosed();
        }
        this.delegate.awaitReadable(time, timeUnit);
    }

    @Override
    public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public void close() throws IOException {
        if (this.isFinished()) {
            return;
        }
        this.delegate.close();
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (this.isFinished()) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        return this.delegate.getOption(option);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.isFinished()) {
            return -1;
        }
        return this.delegate.read(dst);
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }
}

