/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowMessages;
import io.undertow.io.BufferWritableOutputStream;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.Bits;
import org.xnio.Buffers;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;

public class UndertowOutputStream
extends OutputStream
implements BufferWritableOutputStream {
    private final HttpServerExchange exchange;
    private ByteBuffer buffer;
    private Pooled<ByteBuffer> pooledBuffer;
    private StreamSinkChannel channel;
    private int state;
    private int written;
    private final long contentLength;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_WRITE_STARTED = 2;
    private static final int MAX_BUFFERS_TO_ALLOCATE = 10;

    public UndertowOutputStream(HttpServerExchange exchange) {
        this.exchange = exchange;
        this.contentLength = exchange.getResponseContentLength();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        ByteBuffer buffer = this.buffer();
        if ((long)len == this.contentLength - (long)this.written || buffer.remaining() < len) {
            if (buffer.remaining() < len) {
                StreamSinkChannel channel = this.channel;
                if (channel == null) {
                    this.channel = channel = this.exchange.getResponseChannel();
                }
                Pool<ByteBuffer> bufferPool = this.exchange.getConnection().getBufferPool();
                ByteBuffer[] buffers = new ByteBuffer[11];
                Pooled[] pooledBuffers = new Pooled[10];
                try {
                    int i;
                    buffers[0] = buffer;
                    int currentOffset = off;
                    int rem = buffer.remaining();
                    buffer.put(b, currentOffset, rem);
                    buffer.flip();
                    currentOffset += rem;
                    int bufferCount = 1;
                    for (i = 0; i < 10; ++i) {
                        Pooled<ByteBuffer> pooled;
                        pooledBuffers[bufferCount - 1] = pooled = bufferPool.allocate();
                        buffers[bufferCount++] = pooled.getResource();
                        int toWrite = len - currentOffset;
                        ByteBuffer cb = pooled.getResource();
                        if (toWrite > cb.remaining()) {
                            rem = cb.remaining();
                            cb.put(b, currentOffset, rem);
                            cb.flip();
                            currentOffset += rem;
                            continue;
                        }
                        cb.put(b, currentOffset, len - currentOffset);
                        currentOffset = len;
                        cb.flip();
                        break;
                    }
                    Channels.writeBlocking(channel, buffers, 0, bufferCount);
                    while (currentOffset < len) {
                        bufferCount = 0;
                        for (i = 0; i < 11; ++i) {
                            ByteBuffer cb = buffers[i];
                            cb.clear();
                            ++bufferCount;
                            int toWrite = len - currentOffset;
                            if (toWrite > cb.remaining()) {
                                rem = cb.remaining();
                                cb.put(b, currentOffset, rem);
                                cb.flip();
                                currentOffset += rem;
                                continue;
                            }
                            cb.put(b, currentOffset, len - currentOffset);
                            currentOffset = len;
                            cb.flip();
                            break;
                        }
                        Channels.writeBlocking(channel, buffers, 0, bufferCount);
                    }
                    buffer.clear();
                }
                finally {
                    Pooled p;
                    for (int i = 0; i < pooledBuffers.length && (p = pooledBuffers[i]) != null; ++i) {
                        p.free();
                    }
                }
            } else {
                buffer.put(b, off, len);
                if (buffer.remaining() == 0) {
                    this.writeBufferBlocking();
                }
            }
        } else {
            buffer.put(b, off, len);
            if (buffer.remaining() == 0) {
                this.writeBufferBlocking();
            }
        }
        this.updateWritten(len);
    }

    private void writeBufferBlocking() throws IOException {
        if (this.channel == null) {
            this.channel = this.exchange.getResponseChannel();
        }
        this.buffer.flip();
        if (this.buffer.hasRemaining()) {
            Channels.writeBlocking(this.channel, this.buffer);
        }
        this.buffer.clear();
        this.state |= 2;
    }

    @Override
    public void write(ByteBuffer[] buffers) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        int len = 0;
        for (ByteBuffer buf : buffers) {
            len += buf.remaining();
        }
        if (len < 1) {
            return;
        }
        if (this.written == 0 && (long)len == this.contentLength) {
            if (this.channel == null) {
                this.channel = this.exchange.getResponseChannel();
            }
            Channels.writeBlocking(this.channel, buffers, 0, buffers.length);
            this.state |= 2;
        } else {
            ByteBuffer buffer = this.buffer();
            if (len < buffer.remaining()) {
                Buffers.copy(buffer, buffers, 0, buffers.length);
            } else {
                if (this.channel == null) {
                    this.channel = this.exchange.getResponseChannel();
                }
                if (buffer.position() == 0) {
                    Channels.writeBlocking(this.channel, buffers, 0, buffers.length);
                } else {
                    ByteBuffer[] newBuffers = new ByteBuffer[buffers.length + 1];
                    buffer.flip();
                    newBuffers[0] = buffer;
                    System.arraycopy(buffers, 0, newBuffers, 1, buffers.length);
                    Channels.writeBlocking(this.channel, newBuffers, 0, newBuffers.length);
                    buffer.clear();
                }
                this.state |= 2;
            }
        }
        this.updateWritten(len);
    }

    @Override
    public void write(ByteBuffer byteBuffer) throws IOException {
        this.write(new ByteBuffer[]{byteBuffer});
    }

    void updateWritten(long len) throws IOException {
        this.written = (int)((long)this.written + len);
        if (this.contentLength != -1L && (long)this.written >= this.contentLength) {
            this.flush();
            this.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        if (this.buffer != null && this.buffer.position() != 0) {
            this.writeBuffer();
        }
        if (this.channel == null) {
            this.channel = this.exchange.getResponseChannel();
        }
        Channels.flushBlocking(this.channel);
    }

    private void writeBuffer() throws IOException {
        this.buffer.flip();
        if (this.channel == null) {
            this.channel = this.exchange.getResponseChannel();
        }
        Channels.writeBlocking(this.channel, this.buffer);
        this.buffer.clear();
        this.state |= 2;
    }

    @Override
    public void transferFrom(FileChannel source) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        if (this.buffer != null && this.buffer.position() != 0) {
            this.writeBuffer();
        }
        if (this.channel == null) {
            this.channel = this.exchange.getResponseChannel();
        }
        long position = source.position();
        long size = source.size();
        Channels.transferBlocking(this.channel, source, position, size);
        this.updateWritten(size - position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            return;
        }
        try {
            this.state |= 1;
            if (Bits.anyAreClear(this.state, 2) && this.channel == null) {
                if (this.buffer == null) {
                    this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "0");
                } else {
                    this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + this.buffer.position());
                }
            }
            if (this.buffer != null) {
                this.writeBuffer();
            }
            if (this.channel == null) {
                this.channel = this.exchange.getResponseChannel();
            }
            StreamSinkChannel channel = this.channel;
            channel.shutdownWrites();
            Channels.flushBlocking(channel);
        }
        finally {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.free();
                this.buffer = null;
            } else {
                this.buffer = null;
            }
        }
    }

    private ByteBuffer buffer() {
        ByteBuffer buffer = this.buffer;
        if (buffer != null) {
            return buffer;
        }
        this.pooledBuffer = this.exchange.getConnection().getBufferPool().allocate();
        this.buffer = this.pooledBuffer.getResource();
        return this.buffer;
    }
}

