/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class RequestSmallerThanPredicate
implements Predicate {
    private final long size;

    RequestSmallerThanPredicate(long size) {
        this.size = size;
    }

    @Override
    public boolean resolve(HttpServerExchange exchange) {
        String length = exchange.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (length == null) {
            return false;
        }
        return Long.parseLong(length) < this.size;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "request-smaller-than";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("size", Long.class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("size");
        }

        @Override
        public String defaultParameter() {
            return "size";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            Long size = (Long)config.get("size");
            return new RequestSmallerThanPredicate(size);
        }
    }
}

