/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.handshake.JsrHybi07Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi08Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi13Handshake;
import java.util.HashSet;
import java.util.Set;

final class JsrWebSocketProtocolHandshakeHandler
extends WebSocketProtocolHandshakeHandler {
    JsrWebSocketProtocolHandshakeHandler(WebSocketConnectionCallback callback, ConfiguredServerEndpoint ... configs) {
        super(JsrWebSocketProtocolHandshakeHandler.handshakes(configs), callback);
    }

    private static Set<Handshake> handshakes(ConfiguredServerEndpoint ... configs) {
        HashSet<Handshake> handshakes = new HashSet<Handshake>();
        for (ConfiguredServerEndpoint config : configs) {
            handshakes.add(new JsrHybi07Handshake(config));
            handshakes.add(new JsrHybi08Handshake(config));
            handshakes.add(new JsrHybi13Handshake(config));
        }
        return handshakes;
    }
}

