/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.UndertowMessages;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieSameSiteMode;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import java.util.Arrays;
import java.util.Date;

public class ServletCookieAdaptor
implements Cookie {
    private final javax.servlet.http.Cookie cookie;
    private boolean sameSite;
    private String sameSiteMode;

    public ServletCookieAdaptor(javax.servlet.http.Cookie cookie) {
        this.cookie = cookie;
    }

    @Override
    public String getName() {
        return this.cookie.getName();
    }

    @Override
    public String getValue() {
        return this.cookie.getValue();
    }

    @Override
    public Cookie setValue(String value) {
        this.cookie.setValue(value);
        return this;
    }

    @Override
    public String getPath() {
        return this.cookie.getPath();
    }

    @Override
    public Cookie setPath(String path) {
        this.cookie.setPath(path);
        return this;
    }

    @Override
    public String getDomain() {
        return this.cookie.getDomain();
    }

    @Override
    public Cookie setDomain(String domain) {
        this.cookie.setDomain(domain);
        return this;
    }

    @Override
    public Integer getMaxAge() {
        return this.cookie.getMaxAge();
    }

    @Override
    public Cookie setMaxAge(Integer maxAge) {
        this.cookie.setMaxAge(maxAge);
        return this;
    }

    @Override
    public boolean isDiscard() {
        return this.cookie.getMaxAge() < 0;
    }

    @Override
    public Cookie setDiscard(boolean discard) {
        return this;
    }

    @Override
    public boolean isSecure() {
        return this.cookie.getSecure();
    }

    @Override
    public Cookie setSecure(boolean secure) {
        this.cookie.setSecure(secure);
        return this;
    }

    @Override
    public int getVersion() {
        return this.cookie.getVersion();
    }

    @Override
    public Cookie setVersion(int version) {
        this.cookie.setVersion(version);
        return this;
    }

    @Override
    public boolean isHttpOnly() {
        return this.cookie.isHttpOnly();
    }

    @Override
    public Cookie setHttpOnly(boolean httpOnly) {
        this.cookie.setHttpOnly(httpOnly);
        return this;
    }

    @Override
    public Date getExpires() {
        return null;
    }

    @Override
    public Cookie setExpires(Date expires) {
        throw UndertowServletMessages.MESSAGES.notImplemented();
    }

    @Override
    public String getComment() {
        return this.cookie.getComment();
    }

    @Override
    public Cookie setComment(String comment) {
        this.cookie.setComment(comment);
        return this;
    }

    @Override
    public boolean isSameSite() {
        return this.sameSite;
    }

    @Override
    public Cookie setSameSite(boolean sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    @Override
    public String getSameSiteMode() {
        return this.sameSiteMode;
    }

    @Override
    public Cookie setSameSiteMode(String mode) {
        String m = CookieSameSiteMode.lookupModeString(mode);
        if (m != null) {
            UndertowServletLogger.REQUEST_LOGGER.tracef("Setting SameSite mode to [%s] for cookie [%s]", (Object)m, (Object)this.getName());
            this.sameSiteMode = m;
            this.setSameSite(true);
        } else {
            UndertowServletLogger.REQUEST_LOGGER.warnf((Throwable)UndertowMessages.MESSAGES.invalidSameSiteMode(mode, Arrays.toString((Object[])CookieSameSiteMode.values())), "Ignoring specified SameSite mode [%s] for cookie [%s]", (Object)mode, (Object)this.getName());
        }
        return this;
    }

    public final int hashCode() {
        int result = 17;
        result = 37 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 37 * result + (this.getPath() == null ? 0 : this.getPath().hashCode());
        result = 37 * result + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        return result;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Cookie)) {
            return false;
        }
        Cookie o = (Cookie)other;
        if (this.getName() == null && o.getName() != null) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(o.getName())) {
            return false;
        }
        if (this.getPath() == null && o.getPath() != null) {
            return false;
        }
        if (this.getPath() != null && !this.getPath().equals(o.getPath())) {
            return false;
        }
        if (this.getDomain() == null && o.getDomain() != null) {
            return false;
        }
        return this.getDomain() == null || this.getDomain().equals(o.getDomain());
    }

    @Override
    public final int compareTo(Object other) {
        return Cookie.super.compareTo(other);
    }

    public final String toString() {
        return "{ServletCookieAdaptor@" + System.identityHashCode(this) + " name=" + this.getName() + " path=" + this.getPath() + " domain=" + this.getDomain() + "}";
    }
}

