/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;

public class DefaultContainerConfigurator
extends ServerEndpointConfig.Configurator {
    public static final DefaultContainerConfigurator INSTANCE = new DefaultContainerConfigurator();
    private static final ThreadLocal<InstanceFactory<?>> currentInstanceFactory = new ThreadLocal();
    private static final ThreadLocal<InstanceHandle<?>> currentInstanceHandle = new ThreadLocal();

    @Override
    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        for (String proto : requested) {
            if (!supported.contains(proto)) continue;
            return proto;
        }
        return "";
    }

    @Override
    public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        ArrayList<Extension> ret = new ArrayList<Extension>();
        block0: for (Extension req : requested) {
            for (Extension extension : installed) {
                if (!extension.getName().equals(req.getName())) continue;
                ret.add(req);
                continue block0;
            }
        }
        return ret;
    }

    @Override
    public boolean checkOrigin(String originHeaderValue) {
        return true;
    }

    @Override
    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
    }

    @Override
    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        InstanceFactory<?> factory = currentInstanceFactory.get();
        if (factory != null) {
            InstanceHandle<?> instance = factory.createInstance();
            currentInstanceHandle.set(instance);
            return (T)instance.getInstance();
        }
        try {
            return endpointClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static void setCurrentInstanceFactory(InstanceFactory<?> factory) {
        currentInstanceFactory.set(factory);
    }

    static InstanceHandle<?> clearCurrentInstanceFactory() {
        currentInstanceFactory.remove();
        InstanceHandle<?> handle = currentInstanceHandle.get();
        currentInstanceHandle.remove();
        return handle;
    }
}

