/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import org.jboss.logmanager.handlers.ClientSocketFactory;
import org.jboss.logmanager.handlers.FlushableCloseable;

public class UdpOutputStream
extends OutputStream
implements FlushableCloseable {
    private final DatagramSocket socket;
    private final SocketAddress socketAddress;

    public UdpOutputStream(InetAddress address, int port) throws IOException {
        this(ClientSocketFactory.of(address, port));
    }

    public UdpOutputStream(ClientSocketFactory socketManager) throws SocketException {
        this.socket = socketManager.createDatagramSocket();
        this.socketAddress = socketManager.getSocketAddress();
    }

    @Override
    public void write(int b) throws IOException {
        byte[] msg = new byte[]{(byte)b};
        DatagramPacket packet = new DatagramPacket(msg, 1, this.socketAddress);
        this.socket.send(packet);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b != null) {
            DatagramPacket packet = new DatagramPacket(b, b.length, this.socketAddress);
            this.socket.send(packet);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b != null) {
            DatagramPacket packet = new DatagramPacket(b, off, len, this.socketAddress);
            this.socket.send(packet);
        }
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }
}

