/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.FormAuthenticationMechanism;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.SavedRequest;
import io.undertow.util.Headers;
import io.undertow.util.RedirectBuilder;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ServletFormAuthenticationMechanism
extends FormAuthenticationMechanism {
    public static final AuthenticationMechanismFactory FACTORY = new Factory();
    private static final String SESSION_KEY = "io.undertow.servlet.form.auth.redirect.location";
    public static final String SAVE_ORIGINAL_REQUEST = "save-original-request";
    private final boolean saveOriginalRequest;
    private final Set<SessionManager> seenSessionManagers = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final String defaultPage;
    private final boolean overrideInitial;
    private static final SessionListener LISTENER = new SessionListener(){

        @Override
        public void sessionCreated(Session session, HttpServerExchange exchange) {
        }

        @Override
        public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
        }

        @Override
        public void attributeAdded(Session session, String name, Object value) {
        }

        @Override
        public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
        }

        @Override
        public void attributeRemoved(Session session, String name, Object oldValue) {
        }

        @Override
        public void sessionIdChanged(Session session, String oldSessionId) {
            String oldPart;
            String oldLocation = (String)session.getAttribute(ServletFormAuthenticationMechanism.SESSION_KEY);
            if (oldLocation != null && oldLocation.contains(oldPart = ";jsessionid=" + oldSessionId)) {
                session.setAttribute(ServletFormAuthenticationMechanism.SESSION_KEY, oldLocation.replace(oldPart, ";jsessionid=" + session.getId()));
            }
        }
    };

    @Deprecated
    public ServletFormAuthenticationMechanism(String name, String loginPage, String errorPage) {
        super(name, loginPage, errorPage);
        this.saveOriginalRequest = true;
        this.defaultPage = null;
        this.overrideInitial = false;
    }

    @Deprecated
    public ServletFormAuthenticationMechanism(String name, String loginPage, String errorPage, String postLocation) {
        super(name, loginPage, errorPage, postLocation);
        this.saveOriginalRequest = true;
        this.defaultPage = null;
        this.overrideInitial = false;
    }

    public ServletFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, String postLocation) {
        super(formParserFactory, name, loginPage, errorPage, postLocation);
        this.saveOriginalRequest = true;
        this.defaultPage = null;
        this.overrideInitial = false;
    }

    public ServletFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage) {
        super(formParserFactory, name, loginPage, errorPage);
        this.saveOriginalRequest = true;
        this.defaultPage = null;
        this.overrideInitial = false;
    }

    public ServletFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, IdentityManager identityManager) {
        super(formParserFactory, name, loginPage, errorPage, identityManager);
        this.saveOriginalRequest = true;
        this.defaultPage = null;
        this.overrideInitial = false;
    }

    public ServletFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, IdentityManager identityManager, boolean saveOriginalRequest) {
        super(formParserFactory, name, loginPage, errorPage, identityManager);
        this.saveOriginalRequest = true;
        this.defaultPage = null;
        this.overrideInitial = false;
    }

    public ServletFormAuthenticationMechanism(FormParserFactory formParserFactory, String name, String loginPage, String errorPage, String defaultPage, boolean overrideInitial, IdentityManager identityManager, boolean saveOriginalRequest) {
        super(formParserFactory, name, loginPage, errorPage, identityManager);
        this.saveOriginalRequest = saveOriginalRequest;
        this.defaultPage = defaultPage;
        this.overrideInitial = overrideInitial;
    }

    @Override
    protected Integer servePage(HttpServerExchange exchange, String location) {
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest req = servletRequestContext.getServletRequest();
        ServletResponse resp = servletRequestContext.getServletResponse();
        RequestDispatcher disp = req.getRequestDispatcher(location);
        exchange.getResponseHeaders().add(Headers.CACHE_CONTROL, "no-cache, no-store, must-revalidate");
        exchange.getResponseHeaders().add(Headers.PRAGMA, "no-cache");
        exchange.getResponseHeaders().add(Headers.EXPIRES, "0");
        FormResponseWrapper respWrapper = exchange.getStatusCode() != 200 && resp instanceof HttpServletResponse ? new FormResponseWrapper((HttpServletResponse)resp) : null;
        try {
            disp.forward(req, respWrapper != null ? respWrapper : resp);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return respWrapper != null ? Integer.valueOf(respWrapper.getStatus()) : null;
    }

    @Override
    protected void storeInitialLocation(HttpServerExchange exchange) {
        this.storeInitialLocation(exchange, null, 0);
    }

    protected void storeInitialLocation(HttpServerExchange exchange, byte[] bytes, int contentLength) {
        SessionManager manager;
        int originalMaxInactiveInterval;
        if (!this.saveOriginalRequest) {
            return;
        }
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletContextImpl servletContextImpl = servletRequestContext.getCurrentServletContext();
        HttpSessionImpl httpSession = servletContextImpl.getSession(exchange, false);
        boolean newSession = false;
        if (httpSession == null) {
            httpSession = servletContextImpl.getSession(exchange, true);
            newSession = true;
        }
        Session session = System.getSecurityManager() == null ? httpSession.getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(httpSession));
        if (newSession && (originalMaxInactiveInterval = session.getMaxInactiveInterval()) > 120) {
            session.setAttribute("io.undertow.servlet.form.auth.orig.session.timeout", session.getMaxInactiveInterval());
            session.setMaxInactiveInterval(120);
        }
        if (this.seenSessionManagers.add(manager = session.getSessionManager())) {
            manager.registerSessionListener(LISTENER);
        }
        session.setAttribute(SESSION_KEY, RedirectBuilder.redirect(exchange, exchange.getRelativePath()));
        if (bytes == null) {
            SavedRequest.trySaveRequest(exchange);
        } else {
            SavedRequest.trySaveRequest(exchange, bytes, contentLength);
        }
    }

    @Override
    protected void handleRedirectBack(HttpServerExchange exchange) {
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletResponse resp = (HttpServletResponse)servletRequestContext.getServletResponse();
        HttpSessionImpl httpSession = servletRequestContext.getCurrentServletContext().getSession(exchange, false);
        if (httpSession != null) {
            String path;
            Session session = System.getSecurityManager() == null ? httpSession.getSession() : AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction(httpSession));
            Integer originalSessionTimeout = (Integer)session.removeAttribute("io.undertow.servlet.form.auth.orig.session.timeout");
            if (originalSessionTimeout != null) {
                session.setMaxInactiveInterval(originalSessionTimeout);
            }
            if (((path = (String)session.getAttribute(SESSION_KEY)) == null || this.overrideInitial) && this.defaultPage != null) {
                path = this.defaultPage;
            }
            if (path != null) {
                try {
                    resp.sendRedirect(path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class Factory
    implements AuthenticationMechanismFactory {
        @Deprecated
        public Factory(IdentityManager identityManager) {
        }

        public Factory() {
        }

        @Override
        public AuthenticationMechanism create(String mechanismName, IdentityManager identityManager, FormParserFactory formParserFactory, Map<String, String> properties) {
            String loginPage = properties.get("login_page");
            String errorPage = properties.get("error_page");
            String defaultPage = properties.get("default_page");
            boolean overrideInitial = properties.containsKey("override_initial") ? Boolean.parseBoolean(properties.get("override_initial")) : false;
            boolean saveOriginal = true;
            if (properties.containsKey(ServletFormAuthenticationMechanism.SAVE_ORIGINAL_REQUEST)) {
                saveOriginal = Boolean.parseBoolean(properties.get(ServletFormAuthenticationMechanism.SAVE_ORIGINAL_REQUEST));
            }
            return new ServletFormAuthenticationMechanism(formParserFactory, mechanismName, loginPage, errorPage, defaultPage, overrideInitial, identityManager, saveOriginal);
        }
    }

    private static class FormResponseWrapper
    extends HttpServletResponseWrapper {
        private int status = 200;

        private FormResponseWrapper(HttpServletResponse wrapped) {
            super(wrapped);
        }

        @Override
        public void setStatus(int sc) {
            this.status = sc;
        }

        @Override
        public int getStatus() {
            return this.status;
        }
    }
}

