/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.servlet.UndertowServletMessages;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Executor;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSourceChannel;

public class UpgradeServletInputStream
extends ServletInputStream {
    private final StreamSourceChannel channel;
    private final ByteBufferPool bufferPool;
    private final Executor ioExecutor;
    private volatile ReadListener listener;
    private static final int FLAG_READY = 1;
    private static final int FLAG_CLOSED = 2;
    private static final int FLAG_FINISHED = 4;
    private static final int FLAG_ON_DATA_READ_CALLED = 8;
    private int state;
    private PooledByteBuffer pooled;

    public UpgradeServletInputStream(StreamSourceChannel channel, ByteBufferPool bufferPool, Executor ioExecutor) {
        this.channel = channel;
        this.bufferPool = bufferPool;
        this.ioExecutor = ioExecutor;
    }

    public boolean isFinished() {
        return Bits.anyAreSet((int)this.state, (int)4);
    }

    public boolean isReady() {
        return Bits.anyAreSet((int)this.state, (int)1) && !this.isFinished();
    }

    public void setReadListener(ReadListener readListener) {
        if (readListener == null) {
            throw UndertowServletMessages.MESSAGES.listenerCannotBeNull();
        }
        if (this.listener != null) {
            throw UndertowServletMessages.MESSAGES.listenerAlreadySet();
        }
        this.listener = readListener;
        this.channel.getReadSetter().set((ChannelListener)new ServletInputStreamChannelListener());
        this.ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                UpgradeServletInputStream.this.channel.wakeupReads();
            }
        });
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        if (this.listener != null) {
            if (Bits.anyAreClear((int)this.state, (int)1)) {
                throw UndertowServletMessages.MESSAGES.streamNotReady();
            }
        } else {
            this.readIntoBuffer();
        }
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer buffer = this.pooled.getBuffer();
        int copied = Math.min(buffer.remaining(), len);
        buffer.get(b, off, copied);
        if (!buffer.hasRemaining()) {
            this.pooled.close();
            this.pooled = null;
            if (this.listener != null) {
                this.readIntoBufferNonBlocking();
            }
        }
        return copied;
    }

    private void readIntoBuffer() throws IOException {
        if (this.pooled == null && !Bits.anyAreSet((int)this.state, (int)4)) {
            this.pooled = this.bufferPool.allocate();
            int res = Channels.readBlocking((ReadableByteChannel)this.channel, (ByteBuffer)this.pooled.getBuffer());
            this.pooled.getBuffer().flip();
            if (res == -1) {
                this.state |= 4;
                this.pooled.close();
                this.pooled = null;
            }
        }
    }

    private void readIntoBufferNonBlocking() throws IOException {
        if (this.pooled == null && !Bits.anyAreSet((int)this.state, (int)6)) {
            this.pooled = this.bufferPool.allocate();
            if (this.listener == null) {
                int res = this.channel.read(this.pooled.getBuffer());
                if (res == 0) {
                    this.pooled.close();
                    this.pooled = null;
                    return;
                }
                this.pooled.getBuffer().flip();
                if (res == -1) {
                    this.state |= 4;
                    this.pooled.close();
                    this.pooled = null;
                }
            } else {
                if (Bits.anyAreClear((int)this.state, (int)1)) {
                    throw UndertowServletMessages.MESSAGES.streamNotReady();
                }
                int res = this.channel.read(this.pooled.getBuffer());
                this.pooled.getBuffer().flip();
                if (res == -1) {
                    this.state |= 4;
                    this.pooled.close();
                    this.pooled = null;
                } else if (res == 0) {
                    this.state &= 0xFFFFFFFE;
                    this.pooled.close();
                    this.pooled = null;
                    if (Thread.currentThread() == this.channel.getIoThread()) {
                        this.channel.resumeReads();
                    } else {
                        this.ioExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                UpgradeServletInputStream.this.channel.resumeReads();
                            }
                        });
                    }
                }
            }
        }
    }

    public int available() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            throw UndertowServletMessages.MESSAGES.streamIsClosed();
        }
        this.readIntoBufferNonBlocking();
        if (Bits.anyAreSet((int)this.state, (int)4)) {
            return 0;
        }
        if (this.pooled == null) {
            return 0;
        }
        return this.pooled.getBuffer().remaining();
    }

    public void close() throws IOException {
        if (Bits.anyAreSet((int)this.state, (int)2)) {
            return;
        }
        this.state |= 6;
        if (this.pooled != null) {
            this.pooled.close();
            this.pooled = null;
        }
        this.channel.suspendReads();
        this.channel.shutdownReads();
    }

    private class ServletInputStreamChannelListener
    implements ChannelListener<StreamSourceChannel> {
        private ServletInputStreamChannelListener() {
        }

        public void handleEvent(StreamSourceChannel channel) {
            if (Bits.anyAreSet((int)UpgradeServletInputStream.this.state, (int)4)) {
                return;
            }
            UpgradeServletInputStream.this.state |= 1;
            try {
                UpgradeServletInputStream.this.readIntoBufferNonBlocking();
                if (UpgradeServletInputStream.this.pooled != null) {
                    UpgradeServletInputStream.this.state |= 1;
                    if (!Bits.anyAreSet((int)UpgradeServletInputStream.this.state, (int)4)) {
                        UpgradeServletInputStream.this.listener.onDataAvailable();
                    }
                }
            }
            catch (Exception e) {
                if (UpgradeServletInputStream.this.pooled != null) {
                    UpgradeServletInputStream.this.pooled.close();
                    UpgradeServletInputStream.this.pooled = null;
                }
                UpgradeServletInputStream.this.listener.onError((Throwable)e);
                IoUtils.safeClose((Closeable)channel);
            }
            if (Bits.anyAreSet((int)UpgradeServletInputStream.this.state, (int)4)) {
                if (Bits.anyAreClear((int)UpgradeServletInputStream.this.state, (int)8)) {
                    try {
                        UpgradeServletInputStream.this.state |= 8;
                        channel.shutdownReads();
                        UpgradeServletInputStream.this.listener.onAllDataRead();
                    }
                    catch (IOException e) {
                        if (UpgradeServletInputStream.this.pooled != null) {
                            UpgradeServletInputStream.this.pooled.close();
                            UpgradeServletInputStream.this.pooled = null;
                        }
                        UpgradeServletInputStream.this.listener.onError((Throwable)e);
                        IoUtils.safeClose((Closeable)channel);
                    }
                }
            } else if (UpgradeServletInputStream.this.isReady()) {
                channel.suspendReads();
            }
        }
    }
}

