/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import jakarta.websocket.server.PathParam;
import java.lang.reflect.Method;
import java.util.Set;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="UT")
public interface JsrWebSocketLogger
extends BasicLogger {
    public static final JsrWebSocketLogger ROOT_LOGGER = Logger.getMessageLogger(JsrWebSocketLogger.class, JsrWebSocketLogger.class.getPackage().getName());
    public static final JsrWebSocketLogger REQUEST_LOGGER = Logger.getMessageLogger(JsrWebSocketLogger.class, JsrWebSocketLogger.class.getPackage().getName() + ".request");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=26001, value="Unable to instantiate endpoint")
    public void endpointCreationFailed(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=26002, value="Unable to instantiate server configuration %s")
    public void couldNotInitializeConfiguration(Class<?> var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=26003, value="Adding annotated server endpoint %s for path %s")
    public void addingAnnotatedServerEndpoint(Class<?> var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=26004, value="Adding annotated client endpoint %s")
    public void addingAnnotatedClientEndpoint(Class<?> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=26005, value="Adding programmatic server endpoint %s for path %s")
    public void addingProgramaticEndpoint(Class<?> var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=26006, value="Exception running web socket method")
    public void exceptionInWebSocketMethod(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=26007, value="On Endpoint class %s path param %s on method %s does not reference a valid parameter, valid parameters are %s.")
    public void pathTemplateNotFound(Class<?> var1, PathParam var2, Method var3, Set<String> var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=26008, value="Could not close endpoint on undeploy.")
    public void couldNotCloseOnUndeploy(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=26009, value="XNIO worker was not set on WebSocketDeploymentInfo, the default worker will be used")
    public void xnioWorkerWasNull();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=26010, value="Buffer pool was not set on WebSocketDeploymentInfo, the default pool will be used")
    public void bufferPoolWasNull();

    @Message(id=26011, value="XNIO worker was not set on WebSocketDeploymentInfo, and there is no default to use")
    public IllegalArgumentException xnioWorkerWasNullAndNoDefault();

    @Message(id=26012, value="Buffer pool was not set on WebSocketDeploymentInfo, and there is no default to use")
    public IllegalArgumentException bufferPoolWasNullAndNoDefault();
}

