/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples.reverseproxy;

import io.undertow.Undertow;
import io.undertow.examples.UndertowExample;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.proxy.mod_cluster.MCMPConfig;
import io.undertow.server.handlers.proxy.mod_cluster.ModCluster;
import java.io.IOException;
import java.net.InetAddress;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

@UndertowExample(value="ModCluster Proxy Server")
public class ModClusterProxyServer {
    static String chost = System.getProperty("io.undertow.examples.proxy.CADDRESS", "localhost");
    static final int cport = Integer.parseInt(System.getProperty("io.undertow.examples.proxy.CPORT", "6666"));
    static String phost = System.getProperty("io.undertow.examples.proxy.ADDRESS", "localhost");
    static final int pport = Integer.parseInt(System.getProperty("io.undertow.examples.proxy.PORT", "8000"));

    public static void main(String[] args) throws IOException {
        XnioWorker worker = Xnio.getInstance().createWorker(OptionMap.EMPTY);
        ModCluster modCluster = ModCluster.builder(worker).build();
        try {
            if (chost == null) {
                chost = InetAddress.getLocalHost().getHostName();
                System.out.println("Using: " + chost + ":" + cport);
            }
            modCluster.start();
            HttpHandler proxy = modCluster.createProxyHandler();
            MCMPConfig config = MCMPConfig.webBuilder().setManagementHost(chost).setManagementPort(cport).enableAdvertise().getParent().build();
            HttpHandler mcmp = config.create(modCluster, proxy);
            Undertow server = Undertow.builder().addHttpListener(cport, chost).addHttpListener(pport, phost).setHandler(mcmp).build();
            server.start();
            modCluster.advertise(config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

