/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples;

import io.undertow.examples.UndertowExample;
import io.undertow.examples.org_wildfly_tranformer_asm_classForName_String__boolean_ClassLoader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xnio.IoUtils;

public class Runner {
    private static final String TARGET_CLASS = "target" + File.separatorChar + "classes" + File.separatorChar;

    public static void main(String[] args) {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        URL url = Runner.class.getClassLoader().getResource(Runner.class.getPackage().getName().replace(".", "/"));
        if (url == null) {
            throw new RuntimeException("Could not locate examples package");
        }
        HashMap<String, Class> examples = new HashMap<String, Class>();
        ZipInputStream in = null;
        boolean fromJarFile = false;
        try {
            Object entry;
            String finalURIString = url.toString();
            if (url.getPath().contains("!")) {
                fromJarFile = true;
                finalURIString = url.getPath().substring(0, url.getPath().indexOf("!"));
            }
            if (fromJarFile) {
                String zipPath = finalURIString.replace("file:", "");
                in = new ZipInputStream(new FileInputStream(zipPath));
                entry = in.getNextEntry();
                while (entry != null) {
                    if (((ZipEntry)entry).getName().endsWith(".class")) {
                        String className = ((ZipEntry)entry).getName().substring(0, ((ZipEntry)entry).getName().length() - 6).replace("/", ".");
                        try {
                            Class<?> clazz2 = org_wildfly_tranformer_asm_classForName_String__boolean_ClassLoader.forName(className);
                            UndertowExample example = clazz2.getAnnotation(UndertowExample.class);
                            if (example != null) {
                                examples.put(example.value(), clazz2);
                            }
                        }
                        catch (Throwable clazz2) {
                            // empty catch block
                        }
                    }
                    entry = in.getNextEntry();
                }
            } else {
                try {
                    Stream<Path> paths = Files.walk(Paths.get(url.toURI()), new FileVisitOption[0]);
                    entry = null;
                    try {
                        Map<String, Class> annotationMapping = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toFile().getName().endsWith(".class")).map(Runner::toFileName).map(fileName -> fileName.replace(File.separator, ".")).map(Runner::instance).filter(Optional::isPresent).filter(clazz -> ((Class)clazz.get()).getAnnotation(UndertowExample.class) != null).collect(Collectors.toMap(clazz -> ((Class)clazz.get()).getAnnotation(UndertowExample.class).value(), Optional::get));
                        examples.putAll(annotationMapping);
                    }
                    catch (Throwable annotationMapping) {
                        entry = annotationMapping;
                        throw annotationMapping;
                    }
                    finally {
                        if (paths != null) {
                            if (entry != null) {
                                try {
                                    paths.close();
                                }
                                catch (Throwable annotationMapping) {
                                    ((Throwable)entry).addSuppressed(annotationMapping);
                                }
                            } else {
                                paths.close();
                            }
                        }
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            ArrayList names = new ArrayList(examples.keySet());
            Collections.sort(names);
            System.out.println("Welcome to the Undertow Examples");
            System.out.println("Please select an example:");
            for (int i = 0; i < names.size(); ++i) {
                System.out.print((char)(97 + i));
                System.out.println(") " + (String)names.get(i));
            }
            byte[] data = new byte[1];
            System.in.read(data);
            String example = (String)names.get(data[0] - 97);
            System.out.println("Running example " + example);
            Class exampleClass = (Class)examples.get(example);
            UndertowExample annotation = exampleClass.getAnnotation(UndertowExample.class);
            System.out.println("Please point your web browser at " + annotation.location());
            Method main = exampleClass.getDeclaredMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtils.safeClose(in);
                throw throwable;
            }
        }
        IoUtils.safeClose((Closeable)in);
    }

    private static String toFileName(Path path) {
        String pathName = path.toFile().getAbsolutePath();
        int index = pathName.indexOf(TARGET_CLASS) + TARGET_CLASS.length();
        int classIndex = pathName.lastIndexOf(".class");
        return pathName.substring(index, classIndex);
    }

    private static Optional<Class<?>> instance(String clazz) {
        try {
            return Optional.ofNullable(org_wildfly_tranformer_asm_classForName_String__boolean_ClassLoader.forName(clazz));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

