/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.WebSocketExtension;
import jakarta.websocket.Extension;
import jakarta.websocket.Extension$Parameter;
import java.util.ArrayList;
import java.util.List;

public class ExtensionImpl
implements Extension {
    private final String name;
    private final List<Extension$Parameter> parameters;

    ExtensionImpl(String name, List<Extension$Parameter> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Extension$Parameter> getParameters() {
        return this.parameters;
    }

    public static Extension create(WebSocketExtension extension) {
        ArrayList<Extension$Parameter> params = new ArrayList<Extension$Parameter>(extension.getParameters().size());
        for (WebSocketExtension.Parameter p : extension.getParameters()) {
            params.add(new ParameterImpl(p.getName(), p.getValue()));
        }
        return new ExtensionImpl(extension.getName(), params);
    }

    public static class ParameterImpl
    implements Extension$Parameter {
        private final String name;
        private final String value;

        public ParameterImpl(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

