/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.sasl;

import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.xnio.Buffers;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;
import org.xnio._private.Messages;
import org.xnio.sasl.SaslQop;
import org.xnio.sasl.org_wildfly_tranformer_asm_classForName_String__boolean_ClassLoader;

public final class SaslUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];

    private SaslUtils() {
    }

    public static Iterator<SaslServerFactory> getSaslServerFactories(ClassLoader classLoader, boolean includeGlobal) {
        return SaslUtils.getFactories(SaslServerFactory.class, classLoader, includeGlobal);
    }

    public static Iterator<SaslServerFactory> getSaslServerFactories() {
        return SaslUtils.getFactories(SaslServerFactory.class, null, true);
    }

    public static Iterator<SaslClientFactory> getSaslClientFactories(ClassLoader classLoader, boolean includeGlobal) {
        return SaslUtils.getFactories(SaslClientFactory.class, classLoader, includeGlobal);
    }

    public static Iterator<SaslClientFactory> getSaslClientFactories() {
        return SaslUtils.getFactories(SaslClientFactory.class, null, true);
    }

    private static <T> Iterator<T> getFactories(Class<T> type, ClassLoader classLoader, boolean includeGlobal) {
        LinkedHashSet<T> factories = new LinkedHashSet<T>();
        ServiceLoader<T> loader = ServiceLoader.load(type, classLoader);
        for (T factory : loader) {
            factories.add(factory);
        }
        if (includeGlobal) {
            HashSet<String> loadedClasses = new HashSet<String>();
            String filter = type.getSimpleName() + ".";
            Provider[] providers = Security.getProviders();
            SecurityManager sm = System.getSecurityManager();
            for (final Provider currentProvider : providers) {
                ClassLoader cl = sm == null ? currentProvider.getClass().getClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return currentProvider.getClass().getClassLoader();
                    }
                });
                for (Object currentKey : currentProvider.keySet()) {
                    String className;
                    if (!(currentKey instanceof String) || !((String)currentKey).startsWith(filter) || ((String)currentKey).indexOf(32) >= 0 || (className = currentProvider.getProperty((String)currentKey)) == null || !loadedClasses.add(className)) continue;
                    try {
                        factories.add(org_wildfly_tranformer_asm_classForName_String__boolean_ClassLoader.forName(className, true, cl).asSubclass(type).newInstance());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (ClassCastException classCastException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            }
        }
        return factories.iterator();
    }

    public static boolean evaluateChallenge(SaslClient client, ByteBuffer destination, ByteBuffer source) throws SaslException {
        byte[] result = SaslUtils.evaluateChallenge(client, source);
        if (result != null) {
            if (destination == null) {
                throw Messages.msg.extraChallenge();
            }
            destination.put(result);
            return false;
        }
        return true;
    }

    public static byte[] evaluateChallenge(SaslClient client, ByteBuffer source) throws SaslException {
        return client.evaluateChallenge(Buffers.take(source));
    }

    public static boolean evaluateResponse(SaslServer server, ByteBuffer destination, ByteBuffer source) throws SaslException {
        byte[] result = SaslUtils.evaluateResponse(server, source);
        if (result != null) {
            if (destination == null) {
                throw Messages.msg.extraResponse();
            }
            destination.put(result);
            return server.isComplete();
        }
        return true;
    }

    public static byte[] evaluateResponse(SaslServer server, ByteBuffer source) throws SaslException {
        return server.evaluateResponse(source.hasRemaining() ? Buffers.take(source) : EMPTY_BYTES);
    }

    public static void wrap(SaslClient client, ByteBuffer destination, ByteBuffer source) throws SaslException {
        destination.put(SaslUtils.wrap(client, source));
    }

    public static byte[] wrap(SaslClient client, ByteBuffer source) throws SaslException {
        byte[] result;
        int len = source.remaining();
        if (len == 0) {
            result = client.wrap(EMPTY_BYTES, 0, len);
        } else if (source.hasArray()) {
            byte[] array = source.array();
            int offs = source.arrayOffset();
            source.position(source.position() + len);
            result = client.wrap(array, offs, len);
        } else {
            result = client.wrap(Buffers.take(source, len), 0, len);
        }
        return result;
    }

    public static void wrap(SaslServer server, ByteBuffer destination, ByteBuffer source) throws SaslException {
        destination.put(SaslUtils.wrap(server, source));
    }

    public static byte[] wrap(SaslServer server, ByteBuffer source) throws SaslException {
        byte[] result;
        int len = source.remaining();
        if (len == 0) {
            result = server.wrap(EMPTY_BYTES, 0, len);
        } else if (source.hasArray()) {
            byte[] array = source.array();
            int offs = source.arrayOffset();
            source.position(source.position() + len);
            result = server.wrap(array, offs, len);
        } else {
            result = server.wrap(Buffers.take(source, len), 0, len);
        }
        return result;
    }

    public static void unwrap(SaslClient client, ByteBuffer destination, ByteBuffer source) throws SaslException {
        destination.put(SaslUtils.unwrap(client, source));
    }

    public static byte[] unwrap(SaslClient client, ByteBuffer source) throws SaslException {
        byte[] result;
        int len = source.remaining();
        if (len == 0) {
            result = client.unwrap(EMPTY_BYTES, 0, len);
        } else if (source.hasArray()) {
            byte[] array = source.array();
            int offs = source.arrayOffset();
            source.position(source.position() + len);
            result = client.unwrap(array, offs, len);
        } else {
            result = client.unwrap(Buffers.take(source, len), 0, len);
        }
        return result;
    }

    public static void unwrap(SaslServer server, ByteBuffer destination, ByteBuffer source) throws SaslException {
        destination.put(SaslUtils.unwrap(server, source));
    }

    public static byte[] unwrap(SaslServer server, ByteBuffer source) throws SaslException {
        byte[] result;
        int len = source.remaining();
        if (len == 0) {
            result = server.unwrap(EMPTY_BYTES, 0, len);
        } else if (source.hasArray()) {
            byte[] array = source.array();
            int offs = source.arrayOffset();
            source.position(source.position() + len);
            result = server.unwrap(array, offs, len);
        } else {
            result = server.unwrap(Buffers.take(source, len), 0, len);
        }
        return result;
    }

    public static Map<String, Object> createPropertyMap(OptionMap optionMap, boolean secure) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        SaslUtils.add(optionMap, Options.SASL_POLICY_FORWARD_SECRECY, propertyMap, "javax.security.sasl.policy.forward", null);
        SaslUtils.add(optionMap, Options.SASL_POLICY_NOACTIVE, propertyMap, "javax.security.sasl.policy.noactive", null);
        SaslUtils.add(optionMap, Options.SASL_POLICY_NOANONYMOUS, propertyMap, "javax.security.sasl.policy.noanonymous", Boolean.TRUE);
        SaslUtils.add(optionMap, Options.SASL_POLICY_NODICTIONARY, propertyMap, "javax.security.sasl.policy.nodictionary", null);
        SaslUtils.add(optionMap, Options.SASL_POLICY_NOPLAINTEXT, propertyMap, "javax.security.sasl.policy.noplaintext", !secure);
        SaslUtils.add(optionMap, Options.SASL_POLICY_PASS_CREDENTIALS, propertyMap, "javax.security.sasl.policy.credentials", null);
        SaslUtils.add(optionMap, Options.SASL_REUSE, propertyMap, "javax.security.sasl.reuse", null);
        SaslUtils.add(optionMap, Options.SASL_SERVER_AUTH, propertyMap, "javax.security.sasl.server.authentication", null);
        SaslUtils.addQopList(optionMap, Options.SASL_QOP, propertyMap, "javax.security.sasl.qop");
        SaslUtils.add(optionMap, Options.SASL_STRENGTH, propertyMap, "javax.security.sasl.strength", null);
        SaslUtils.addSaslProperties(optionMap, Options.SASL_PROPERTIES, propertyMap);
        return propertyMap;
    }

    private static <T> void add(OptionMap optionMap, Option<T> option, Map<String, Object> map, String propName, T defaultVal) {
        T value = optionMap.get(option, defaultVal);
        if (value != null) {
            map.put(propName, value.toString().toLowerCase(Locale.US));
        }
    }

    private static void addQopList(OptionMap optionMap, Option<Sequence<SaslQop>> option, Map<String, Object> map, String propName) {
        Sequence<SaslQop> value = optionMap.get(option);
        if (value == null) {
            return;
        }
        Sequence<SaslQop> seq = value;
        StringBuilder builder = new StringBuilder();
        Iterator<SaslQop> iterator = seq.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        do {
            builder.append(iterator.next().getString());
            if (!iterator.hasNext()) continue;
            builder.append(',');
        } while (iterator.hasNext());
        map.put(propName, builder.toString());
    }

    private static void addSaslProperties(OptionMap optionMap, Option<Sequence<Property>> option, Map<String, Object> map) {
        Sequence<Property> value = optionMap.get(option);
        if (value == null) {
            return;
        }
        for (Property current : value) {
            map.put(current.getKey(), current.getValue());
        }
    }
}

