/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.http2.tests.framework;

import io.undertow.http2.tests.framework.ServerController;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.XnioSsl;

public class Http2TestRunner
extends BlockJUnit4ClassRunner {
    private static final String SERVER_KEY_STORE = "server.keystore";
    private static final String SERVER_TRUST_STORE = "server.truststore";
    private static final String CLIENT_KEY_STORE = "client.keystore";
    private static final String CLIENT_TRUST_STORE = "client.truststore";
    private static final char[] STORE_PASSWORD = "password".toCharArray();
    public static final int BUFFER_SIZE = Integer.getInteger("test.bufferSize", 8192);
    private static XnioWorker worker;
    private static boolean first;
    private static SSLContext clientSslContext;
    private static Xnio xnio;
    private static XnioSsl xnioSsl;
    private static Pool<ByteBuffer> bufferPool;
    private static ServerController serverController;
    private static final Logger log;

    public Http2TestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public static Pool<ByteBuffer> getBufferPool() {
        return bufferPool;
    }

    public Description getDescription() {
        return super.getDescription();
    }

    public void run(RunNotifier notifier) {
        Http2TestRunner.runInternal(notifier);
        super.run(notifier);
    }

    private static void runInternal(RunNotifier notifier) {
        if (first) {
            Http2TestRunner.assertAlpnEnabled();
            first = false;
            xnio = Xnio.getInstance((String)"nio", (ClassLoader)Http2TestRunner.class.getClassLoader());
            try {
                worker = Xnio.getInstance().createWorker(OptionMap.EMPTY);
                serverController.start(Http2TestRunner.getHostAddress(), Http2TestRunner.getHostPort(), Http2TestRunner.getHostSSLPort());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            notifier.addListener(new RunListener(){

                public void testRunFinished(Result result) throws Exception {
                    worker.shutdownNow();
                    serverController.stop();
                }
            });
        }
    }

    public static SSLContext getClientSSLContext() {
        if (clientSslContext == null) {
            clientSslContext = Http2TestRunner.createClientSslContext();
        }
        return clientSslContext;
    }

    private static SSLContext createClientSslContext() {
        try {
            return Http2TestRunner.createSSLContext(Http2TestRunner.loadKeyStore(CLIENT_KEY_STORE), Http2TestRunner.loadKeyStore(CLIENT_TRUST_STORE));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLContext getServerSslContext() {
        try {
            return Http2TestRunner.createSSLContext(Http2TestRunner.loadKeyStore(SERVER_KEY_STORE), Http2TestRunner.loadKeyStore(SERVER_TRUST_STORE));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getHostAddress() {
        return System.getProperty("server.address", "localhost");
    }

    public static int getHostPort() {
        return Integer.getInteger("server.port", 7777);
    }

    public static int getHostSSLPort() {
        return Integer.getInteger("server.sslPort", 7778);
    }

    public static XnioWorker getWorker() {
        return worker;
    }

    private static void assertAlpnEnabled() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.jetty.alpn.ALPN");
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"Jetty ALPN was not found on the boot class path, tests cannot be run");
        }
    }

    private static KeyStore loadKeyStore(String name) throws IOException {
        InputStream stream = Http2TestRunner.class.getClassLoader().getResourceAsStream(name);
        try {
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, STORE_PASSWORD);
            KeyStore keyStore = loadedKeystore;
            return keyStore;
        }
        catch (KeyStoreException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        catch (CertificateException e) {
            throw new IOException(String.format("Unable to load KeyStore %s", name), e);
        }
        finally {
            IoUtils.safeClose((Closeable)stream);
        }
    }

    private static SSLContext createSSLContext(KeyStore keyStore, KeyStore trustStore) throws IOException {
        SSLContext sslContext;
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, STORE_PASSWORD);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to initialise KeyManager[]", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException("Unable to initialise KeyManager[]", e);
        }
        catch (KeyStoreException e) {
            throw new IOException("Unable to initialise KeyManager[]", e);
        }
        TrustManager[] trustManagers = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to initialise TrustManager[]", e);
        }
        catch (KeyStoreException e) {
            throw new IOException("Unable to initialise TrustManager[]", e);
        }
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unable to create and initialise the SSLContext", e);
        }
        catch (KeyManagementException e) {
            throw new IOException("Unable to create and initialise the SSLContext", e);
        }
        return sslContext;
    }

    public static XnioSsl getClientXnioSsl() {
        if (xnioSsl == null) {
            xnioSsl = new JsseXnioSsl(Xnio.getInstance(), OptionMap.EMPTY, Http2TestRunner.getClientSSLContext());
        }
        return xnioSsl;
    }

    static {
        first = true;
        bufferPool = new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, BUFFER_SIZE, BUFFER_SIZE);
        try {
            serverController = (ServerController)Http2TestRunner.class.getClassLoader().loadClass(System.getProperty("server.controller.class", "io.undertow.http2.tests.framework.UndertowTestServer")).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log = Logger.getLogger(Http2TestRunner.class);
    }
}

