/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.http2.tests.framework;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.http2.Http2ClientConnection;
import io.undertow.http2.tests.framework.HttpResponse;
import io.undertow.util.HeaderValues;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.channels.StreamSourceChannel;

public class Http2Client {
    private final ClientConnection connection;

    public Http2Client(ClientConnection connection) {
        this.connection = connection;
        Assert.assertTrue((boolean)(connection instanceof Http2ClientConnection));
    }

    public HttpResponse sendRequest(ClientRequest request) throws IOException {
        final FutureResult result = new FutureResult();
        this.connection.sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

            public void completed(ClientExchange exchange) {
                final ByteArrayOutputStream out = new ByteArrayOutputStream();
                exchange.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange exchange) {
                        StreamSourceChannel source = exchange.getResponseChannel();
                        final ByteBuffer buffer = ByteBuffer.wrap(new byte[1024]);
                        while (true) {
                            try {
                                while (true) {
                                    int res;
                                    if ((res = source.read(buffer)) == -1) {
                                        this.handleDone(exchange, out);
                                        return;
                                    }
                                    if (res == 0) {
                                        source.getReadSetter().set((ChannelListener)new ChannelListener<StreamSourceChannel>(){

                                            public void handleEvent(StreamSourceChannel channel) {
                                                while (true) {
                                                    try {
                                                        while (true) {
                                                            int res;
                                                            if ((res = channel.read(buffer)) == -1) {
                                                                this.handleDone(exchange, out);
                                                                return;
                                                            }
                                                            if (res == 0) {
                                                                return;
                                                            }
                                                            buffer.flip();
                                                            out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.arrayOffset() + buffer.limit());
                                                            buffer.clear();
                                                        }
                                                    }
                                                    catch (IOException e) {
                                                        result.setException(e);
                                                        continue;
                                                    }
                                                    break;
                                                }
                                            }
                                        });
                                        source.resumeReads();
                                        return;
                                    }
                                    buffer.flip();
                                    out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.arrayOffset() + buffer.limit());
                                    buffer.clear();
                                }
                            }
                            catch (IOException e) {
                                result.setException(e);
                                continue;
                            }
                            break;
                        }
                    }

                    public void failed(IOException e) {
                        result.setException(e);
                    }
                });
            }

            public void failed(IOException e) {
                result.setException(e);
            }

            private void handleDone(ClientExchange exchange, ByteArrayOutputStream out) {
                HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                ClientResponse response = exchange.getResponse();
                for (HeaderValues header : response.getResponseHeaders()) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String val : header) {
                        values.add(val);
                    }
                    headers.put(header.getHeaderName().toString(), Collections.unmodifiableList(values));
                }
                result.setResult((Object)new HttpResponse(response.getResponseCode(), headers, out.toByteArray()));
            }
        });
        if (result.getIoFuture().await(10L, TimeUnit.SECONDS) == IoFuture.Status.WAITING) {
            throw new IOException("Timed out");
        }
        return (HttpResponse)result.getIoFuture().get();
    }
}

