/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.jakartaee9;

import io.undertow.jakartaee9.TransformConstants;

class ArtifactNameTransformer {
    private static final String JAKARTA_EE9_SUFFIX = "-jakartaee9";

    ArtifactNameTransformer() {
    }

    static String transformArtifactName(String fileName, String artifactType) {
        return ArtifactNameTransformer.getArtifactName(fileName, artifactType) + JAKARTA_EE9_SUFFIX;
    }

    static String transformArtifactFileName(String fileName, String artifactType) {
        String outputFileSuffix = "-jakartaee9-" + TransformConstants.VERSION_STRING + "." + artifactType;
        return ArtifactNameTransformer.getArtifactName(fileName, artifactType) + outputFileSuffix;
    }

    static String getArtifactName(String fileName, String artifactType) {
        String inputFileSuffix = "-" + TransformConstants.VERSION_STRING + "." + artifactType;
        return fileName.substring(0, fileName.length() - inputFileSuffix.length());
    }
}

