/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;

public class ServletRequestedSessionIdAttribute
implements ExchangeAttribute {
    public static final String REQUESTED_SESSION_ID = "%{REQUESTED_SESSION_ID}";
    public static final ServletRequestedSessionIdAttribute INSTANCE = new ServletRequestedSessionIdAttribute();

    public String readAttribute(HttpServerExchange exchange) {
        ServletRequest req;
        ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        if (context != null && (req = context.getServletRequest()) instanceof HttpServletRequest) {
            return ((HttpServletRequest)req).getRequestedSessionId();
        }
        return null;
    }

    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Session ID", newValue);
    }

    public String toString() {
        return REQUESTED_SESSION_ID;
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        public String name() {
            return "Requested Session ID attribute";
        }

        public ExchangeAttribute build(String token) {
            if (token.equals(ServletRequestedSessionIdAttribute.REQUESTED_SESSION_ID)) {
                return INSTANCE;
            }
            return null;
        }

        public int priority() {
            return 0;
        }
    }
}

