/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.dispatcher;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ResourceLoader;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.dispatcher.IncludeServlet;
import io.undertow.servlet.test.util.MessageFilter;
import io.undertow.servlet.test.util.MessageServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class DispatcherIncludeTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setResourceLoader((ResourceLoader)new TestResourceLoader(DispatcherIncludeTestCase.class)).addServlet(new ServletInfo("include", MessageServlet.class).addInitParam("message", "included").addMapping("/include")).addServlet(new ServletInfo("dispatcher", IncludeServlet.class).addMapping("/dispatch")).addFilter(new FilterInfo("notIncluded", MessageFilter.class).addInitParam("message", "Not Included")).addFilter(new FilterInfo("inc", MessageFilter.class).addInitParam("message", "Path!")).addFilter(new FilterInfo("nameFilter", MessageFilter.class).addInitParam("message", "Name!")).addFilterUrlMapping("notIncluded", "/include", DispatcherType.REQUEST).addFilterUrlMapping("inc", "/include", DispatcherType.INCLUDE).addFilterServletNameMapping("nameFilter", "include", DispatcherType.INCLUDE);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathBasedInclude() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            get.setHeader("include", "/include");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Hello Path!Name!included", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameBasedInclude() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            get.setHeader("include", "include");
            get.setHeader("name", "true");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Hello Name!included", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathBasedStaticInclude() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            get.setHeader("include", "/snippet.html");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Hello SnippetText", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPathBasedStaticIncludePost() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL() + "/servletContext/dispatch");
            post.setHeader("include", "/snippet.html");
            HttpResponse result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"Hello SnippetText", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

