/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.ssl;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.ssl.SSLAttributesServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.test.utils.AjpIgnore;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@AjpIgnore
public class SSLMetaDataTestCase {
    @BeforeClass
    public static void setup() throws Exception {
        DefaultServer.startSSLServer();
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", SSLAttributesServlet.class).addMapping("/id").addMapping("/cert").addMapping("/key-size").addMapping("/cipher-suite");
        DeploymentInfo info = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setResourceLoader(TestResourceLoader.NOOP_RESOURCE_LOADER).addServlet(s);
        DeploymentManager manager = container.addDeployment(info);
        manager.deploy();
        root.addPath(info.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        DefaultServer.stopSSLServer();
    }

    @Test
    public void testSessionId() throws IOException {
        this.internalTest("/id");
    }

    @Test
    public void testCipherSuite() throws IOException {
        this.internalTest("/cipher-suite");
    }

    @Test
    public void testKeySize() throws IOException {
        this.internalTest("/key-size");
    }

    @Test
    public void testCert() throws IOException {
        this.internalTest("/cert");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTest(String path) throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        String url = DefaultServer.getDefaultServerSSLAddress() + "/servletContext" + path;
        try {
            HttpGet get = new HttpGet(url);
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertTrue((response.length() > 0 ? 1 : 0) != 0);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

