/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.request.async;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;

public class TestListener
implements ServletRequestListener {
    private static final List<String> RESULTS = Collections.synchronizedList(new ArrayList());
    private static volatile CountDownLatch latch;

    public static void init(int count) {
        RESULTS.clear();
        latch = new CountDownLatch(count);
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        RESULTS.add("destroyed " + sre.getServletRequest().getDispatcherType());
        latch.countDown();
    }

    public void requestInitialized(ServletRequestEvent sre) {
        RESULTS.add("created " + sre.getServletRequest().getDispatcherType());
        latch.countDown();
    }

    public static List<String> results() {
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return RESULTS;
    }
}

