/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.path;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.path.PathFilter;
import io.undertow.servlet.test.path.PathMappingServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FilterPathMappingTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicFilterMappings() throws IOException, ServletException {
        DeploymentInfo builder = new DeploymentInfo();
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        builder.addServlet(new ServletInfo("/a/*", PathMappingServlet.class).addMapping("/a/*"));
        builder.addServlet(new ServletInfo("/aa", PathMappingServlet.class).addMapping("/aa"));
        builder.addServlet(new ServletInfo("/", PathMappingServlet.class).addMapping("/"));
        builder.addServlet(new ServletInfo("contextRoot", PathMappingServlet.class).addMapping(""));
        builder.addFilter(new FilterInfo("/*", PathFilter.class));
        builder.addFilterUrlMapping("/*", "/*", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("/a/*", PathFilter.class));
        builder.addFilterUrlMapping("/a/*", "/a/*", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("/aa", PathFilter.class));
        builder.addFilterUrlMapping("/aa", "/aa", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("*.bop", PathFilter.class));
        builder.addFilterUrlMapping("*.bop", "*.bop", DispatcherType.REQUEST);
        builder.addFilter(new FilterInfo("contextRoot", PathFilter.class));
        builder.addFilterServletNameMapping("contextRoot", "contextRoot", DispatcherType.REQUEST);
        builder.setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(FilterPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war");
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
        TestHttpClient client = new TestHttpClient();
        try {
            this.runTest(client, "aa", "/aa - null", "/*", "/aa");
            this.runTest(client, "a/c", "/a/* - /c", "/*", "/a/*");
            this.runTest(client, "a", "/a/* - null", "/*", "/a/*");
            this.runTest(client, "aa/b", "/ - /aa/b", "/*");
            this.runTest(client, "a/b/c/d", "/a/* - /b/c/d", "/*", "/a/*");
            this.runTest(client, "defaultStuff", "/ - /defaultStuff", "/*");
            this.runTest(client, "", "contextRoot - null", "/*", "contextRoot");
            this.runTest(client, "yyyy.bop", "/ - null", "/*", "*.bop");
            this.runTest(client, "a/yyyy.bop", "/a/* - /yyyy.bop", "/*", "*.bop", "/a/*");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExtensionMatchServletWithGlobalFilter() throws IOException, ServletException {
        DeploymentInfo builder = new DeploymentInfo();
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        builder.addServlet(new ServletInfo("*.jsp", PathMappingServlet.class).addMapping("*.jsp"));
        builder.addFilter(new FilterInfo("/*", PathFilter.class));
        builder.addFilterUrlMapping("/*", "/*", DispatcherType.REQUEST);
        builder.setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(FilterPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war");
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
        TestHttpClient client = new TestHttpClient();
        try {
            this.runTest(client, "aa.jsp", "*.jsp - null", "/*");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void runTest(TestHttpClient client, String path, String expected, String ... headers) throws IOException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/" + path);
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        this.requireHeaders(result, headers);
        String response = HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertEquals((Object)expected, (Object)response);
    }

    private void requireHeaders(HttpResponse result, String ... headers) {
        Header[] resultHeaders = result.getAllHeaders();
        ArrayList<Header> realResultHeaders = new ArrayList<Header>();
        for (Header header : resultHeaders) {
            if (!header.getName().startsWith("filter")) continue;
            realResultHeaders.add(header);
        }
        HashSet<String> found = new HashSet<String>(Arrays.asList(headers));
        for (Header header : realResultHeaders) {
            if (found.remove(header.getValue())) continue;
            Assert.fail((String)("Found unexpected header " + header.getValue()));
        }
        if (!found.isEmpty()) {
            Assert.fail((String)("header(s) not found " + found));
        }
    }
}

