/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.ordering;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CookieHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.listener.ordering.FirstListener;
import io.undertow.servlet.test.listener.ordering.SecondListener;
import io.undertow.servlet.test.util.EmptyServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.Tracker;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletSessionListenerOrderingTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        CookieHandler cookieHandler = new CookieHandler();
        PathHandler path = new PathHandler();
        cookieHandler.setNext((HttpHandler)path);
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/listener").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("listener.war").addListener(new ListenerInfo(FirstListener.class)).addListener(new ListenerInfo(SecondListener.class)).addServlet(new ServletInfo("message", EmptyServlet.class).addMapping("/*"));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        path.addPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)cookieHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleSessionUsage() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            Tracker.reset();
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/listener/test");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            ArrayList<String> expected = new ArrayList<String>();
            expected.add(FirstListener.class.getSimpleName());
            expected.add(SecondListener.class.getSimpleName());
            expected.add(SecondListener.class.getSimpleName());
            expected.add(FirstListener.class.getSimpleName());
            Assert.assertEquals(expected, Tracker.getActions());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

