/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.CookieHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.session.ChangeSessionIdListener;
import io.undertow.servlet.test.session.ChangeSessionIdServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ChangeSessionIdTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        CookieHandler cookieHandler = new CookieHandler();
        PathHandler path = new PathHandler();
        cookieHandler.setNext((HttpHandler)path);
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", ChangeSessionIdServlet.class).addMapping("/aa");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addListener(new ListenerInfo(ChangeSessionIdListener.class)).addServlet(s);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        path.addPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)cookieHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeSessionId() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/aa");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            String oldId = this.testResponse(response, null);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            oldId = this.testResponse(response, oldId);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            oldId = this.testResponse(response, oldId);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private String testResponse(String response, String expectedOld) {
        String[] parts = response.split(" ");
        Assert.assertEquals((long)2L, (long)parts.length);
        String oldId = parts[0];
        String newId = parts[1];
        if (expectedOld != null) {
            Assert.assertEquals((Object)expectedOld, (Object)oldId);
        }
        Assert.assertFalse((boolean)oldId.isEmpty());
        Assert.assertFalse((boolean)newId.isEmpty());
        Assert.assertFalse((boolean)oldId.equals(newId));
        Assert.assertEquals((Object)oldId, (Object)ChangeSessionIdListener.oldId);
        Assert.assertEquals((Object)newId, (Object)ChangeSessionIdListener.newId);
        return newId;
    }
}

