/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.errorpage;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.errorpage.ChildException;
import io.undertow.servlet.test.errorpage.ErrorServlet;
import io.undertow.servlet.test.errorpage.ParentException;
import io.undertow.servlet.test.errorpage.PathServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ErrorPageTestCase {
    @BeforeClass
    public static void setup() throws IOException, ServletException {
        DeploymentInfo builder = new DeploymentInfo();
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        builder.addServlet(new ServletInfo("error", ErrorServlet.class).addMapping("/error"));
        builder.addServlet(new ServletInfo("path", PathServlet.class).addMapping("/*"));
        builder.addErrorPage(new ErrorPage("/defaultErrorPage"));
        builder.addErrorPage(new ErrorPage("/404", 404));
        builder.addErrorPage(new ErrorPage("/500", 500));
        builder.addErrorPage(new ErrorPage("/parentException", ParentException.class));
        builder.addErrorPage(new ErrorPage("/childException", ChildException.class));
        builder.addErrorPage(new ErrorPage("/runtimeException", RuntimeException.class));
        builder.setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ErrorPageTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war");
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorPages() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            this.runTest(client, 404, null, "/404");
            this.runTest(client, 500, null, "/500");
            this.runTest(client, 501, null, "/defaultErrorPage");
            this.runTest(client, null, ParentException.class, "/parentException");
            this.runTest(client, null, ChildException.class, "/childException");
            this.runTest(client, null, RuntimeException.class, "/runtimeException");
            this.runTest(client, null, IllegalStateException.class, "/runtimeException");
            this.runTest(client, null, Exception.class, "/defaultErrorPage");
            this.runTest(client, null, IOException.class, "/defaultErrorPage");
            this.runTest(client, null, ServletException.class, "/defaultErrorPage");
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private void runTest(TestHttpClient client, Integer statusCode, Class<?> exception, String expected) throws IOException {
        HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/error?" + (statusCode != null ? "statusCode=" + statusCode : "exception=" + exception.getName()));
        HttpResponse result = client.execute((HttpUriRequest)get);
        Assert.assertEquals((long)(statusCode == null ? 500L : (long)statusCode.intValue()), (long)result.getStatusLine().getStatusCode());
        String response = HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertEquals((Object)expected, (Object)response);
    }
}

