/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import java.util.Map;

public class ErrorPages {
    private final Map<Integer, String> errorCodeLocations;
    private final Map<Class<? extends Throwable>, String> exceptionMappings;

    public ErrorPages(Map<Integer, String> errorCodeLocations, Map<Class<? extends Throwable>, String> exceptionMappings) {
        this.errorCodeLocations = errorCodeLocations;
        this.exceptionMappings = exceptionMappings;
    }

    public String getErrorLocation(int code) {
        return this.errorCodeLocations.get(code);
    }

    public String getErrorLocation(Throwable exception) {
        if (exception == null) {
            return null;
        }
        String e = null;
        for (Class<?> c = exception.getClass(); c != null && e == null; c = c.getSuperclass()) {
            e = this.exceptionMappings.get(c);
        }
        return e;
    }
}

