/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import java.util.Map;
import javax.servlet.SessionCookieConfig;

public class SessionCookieConfigImpl
implements SessionCookieConfig,
SessionConfig {
    public static final String DEFAULT_SESSION_ID = "JSESSIONID";
    private String name = "JSESSIONID";
    private String path = "/";
    private String domain;
    private boolean secure;
    private boolean httpOnly;
    private int maxAge;
    private String comment;

    public String rewriteUrl(String originalUrl, Session session) {
        return originalUrl;
    }

    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        Cookie cookie = new CookieImpl(this.name, sessionId).setPath(this.path).setDomain(this.domain).setSecure(this.secure).setHttpOnly(this.httpOnly).setComment(this.comment);
        if (this.maxAge > 0) {
            cookie.setMaxAge(Integer.valueOf(this.maxAge));
        }
        CookieImpl.addResponseCookie((HttpServerExchange)exchange, (Cookie)cookie);
    }

    public void clearSession(HttpServerExchange exchange, String sessionId) {
        CookieImpl cookie = new CookieImpl(this.name, sessionId).setPath(this.path).setDomain(this.domain).setSecure(this.secure).setHttpOnly(this.httpOnly).setMaxAge(Integer.valueOf(0));
        CookieImpl.addResponseCookie((HttpServerExchange)exchange, (Cookie)cookie);
    }

    public String findSessionId(HttpServerExchange exchange) {
        Cookie sessionId;
        Map cookies = CookieImpl.getRequestCookies((HttpServerExchange)exchange);
        if (cookies != null && (sessionId = (Cookie)cookies.get(this.name)) != null) {
            return sessionId.getValue();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }
}

