/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.upgrade;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;

public class AsyncUpgradeServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.upgrade(Handler.class);
    }

    private static class Listener
    implements WriteListener,
    ReadListener {
        private final WebConnection connection;
        StringBuilder builder = new StringBuilder();
        boolean reading = true;

        private Listener(WebConnection connection) {
            this.connection = connection;
        }

        public synchronized void onDataAvailable() throws IOException {
            byte[] data = new byte[100];
            while (this.connection.getInputStream().isReady()) {
                int read = this.connection.getInputStream().read(data);
                if (read != -1) {
                    this.builder.append(new String(data, 0, read));
                }
                if (!this.builder.toString().endsWith("\r\n\r\n")) continue;
                this.reading = false;
                this.onWritePossible();
            }
        }

        public void onAllDataRead() throws IOException {
        }

        public synchronized void onWritePossible() throws IOException {
            if (this.builder.toString().equals("exit\r\n\r\n")) {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.reading) {
                return;
            }
            if (this.connection.getOutputStream().isReady()) {
                this.connection.getOutputStream().print(this.builder.toString());
                this.builder = new StringBuilder();
                this.reading = true;
            }
        }

        public void onError(Throwable t) {
        }
    }

    public static class Handler
    implements HttpUpgradeHandler {
        public void init(WebConnection wc) {
            Listener listener = new Listener(wc);
            try {
                wc.getOutputStream().setWriteListener((WriteListener)listener);
                wc.getInputStream().setReadListener((ReadListener)listener);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void destroy() {
        }
    }
}

