/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.charset;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.charset.CharsetServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class CharacterEncodingTestCase {
    private static final byte[] UTF16 = CharacterEncodingTestCase.toByteArray(new int[]{0, 65, 0, 169, 0, 233, 3, 1, 9, 65, 216, 53, 221, 10});
    private static final byte[] UTF8 = CharacterEncodingTestCase.toByteArray(new int[]{65, 194, 169, 195, 169, 204, 129, 224, 165, 129, 240, 157, 148, 138});

    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", CharsetServlet.class).addMapping("/");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setResourceLoader(TestResourceLoader.NOOP_RESOURCE_LOADER).addServlet(s);
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    public static byte[] toByteArray(int[] source) {
        byte[] ret = new byte[source.length];
        for (int i = 0; i < source.length; ++i) {
            ret[i] = (byte)(0xFF & source[i]);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCharacterEncoding() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext?charset=UTF-16BE");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            byte[] response = HttpClientUtils.readRawResponse((HttpResponse)result);
            Assert.assertArrayEquals((byte[])UTF16, (byte[])response);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext?charset=UTF-8");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readRawResponse((HttpResponse)result);
            Assert.assertArrayEquals((byte[])UTF8, (byte[])response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

