/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.ssl;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.constraint.SendSchemeMessageServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestConfidentialPortManager;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.test.utils.AjpIgnore;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import javax.servlet.annotation.ServletSecurity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
@AjpIgnore
public class ConfidentialityConstraintUrlMappingTestCase {
    @BeforeClass
    public static void setup() throws Exception {
        DefaultServer.startSSLServer();
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", SendSchemeMessageServlet.class).addMapping("/clear").addMapping("/integral").addMapping("/confidential");
        DeploymentInfo info = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setResourceLoader(TestResourceLoader.NOOP_RESOURCE_LOADER).setConfidentialPortManager((ConfidentialPortManager)TestConfidentialPortManager.INSTANCE).addServlet(s);
        info.addSecurityConstraint((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/integral")).setTransportGuaranteeType(TransportGuaranteeType.INTEGRAL)).setEmptyRoleSemantic(ServletSecurity.EmptyRoleSemantic.PERMIT));
        info.addSecurityConstraint((SecurityConstraint)((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/confidential")).setTransportGuaranteeType(TransportGuaranteeType.CONFIDENTIAL)).setEmptyRoleSemantic(ServletSecurity.EmptyRoleSemantic.PERMIT));
        DeploymentManager manager = container.addDeployment(info);
        manager.deploy();
        root.addPath(info.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        DefaultServer.stopSSLServer();
    }

    @Test
    public void testClear() throws IOException {
        this.internalTest("/clear", "http");
    }

    @Test
    public void testIntegral() throws IOException {
        this.internalTest("/integral", "https");
    }

    @Test
    public void testConfidential() throws IOException {
        this.internalTest("/confidential", "https");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTest(String path, String expectedScheme) throws IOException {
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        String url = DefaultServer.getDefaultServerURL() + "/servletContext" + path;
        try {
            HttpGet get = new HttpGet(url);
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)expectedScheme, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

