/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.upgrade;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.upgrade.AsyncUpgradeServlet;
import io.undertow.servlet.test.upgrade.UpgradeServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.test.utils.AjpIgnore;
import io.undertow.test.utils.DefaultServer;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.servlet.ServletException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@AjpIgnore
@RunWith(value=DefaultServer.class)
public class SimpleUpgradeTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo a1 = new ServletInfo("upgradeServlet", UpgradeServlet.class).addMapping("/upgrade");
        ServletInfo a2 = new ServletInfo("upgradeAsyncServlet", AsyncUpgradeServlet.class).addMapping("/asyncupgrade");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setResourceLoader(TestResourceLoader.NOOP_RESOURCE_LOADER).addServlets(new ServletInfo[]{a1, a2});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @Test
    public void testBlockingUpgrade() throws IOException {
        this.runTest("/servletContext/upgrade");
    }

    @Test
    public void testAsyncUpgrade() throws IOException {
        this.runTest("/servletContext/asyncupgrade");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String url) throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            Socket socket = new Socket(DefaultServer.getHostAddress((String)"default"), DefaultServer.getHostPort((String)"default"));
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            out.write(("GET " + url + " HTTP/1.1\r\nConnection: upgrade\r\n\r\n").getBytes());
            out.flush();
            Assert.assertEquals((Object)"HTTP/1.1 101 Switching Protocols\r\nContent-Length: 0\r\n\r\n", (Object)this.readBytes(in));
            out.write("Echo Messages\r\n\r\n".getBytes());
            Assert.assertEquals((Object)"Echo Messages\r\n\r\n", (Object)this.readBytes(in));
            out.write("Echo Messages2\r\n\r\n".getBytes());
            Assert.assertEquals((Object)"Echo Messages2\r\n\r\n", (Object)this.readBytes(in));
            out.write("exit\r\n\r\n".getBytes());
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private String readBytes(InputStream in) throws IOException {
        int read;
        StringBuilder builder = new StringBuilder();
        byte[] buf = new byte[100];
        while (!builder.toString().endsWith("\r\n\r\n") && (read = in.read(buf)) != -1) {
            builder.append(new String(buf, 0, read));
        }
        return builder.toString();
    }
}

