/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.websocket;

import io.undertow.server.HttpHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.streams.ServletOutputStreamTestCase;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import io.undertow.servlet.websockets.WebSocketServlet;
import io.undertow.test.utils.AjpIgnore;
import io.undertow.test.utils.DefaultServer;
import io.undertow.util.ConcreteIoFuture;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.handler.WebSocketConnectionCallback;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import io.undertow.websockets.utils.FrameChecker;
import io.undertow.websockets.utils.WebSocketTestClient;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.james.mime4j.util.CharsetUtil;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelListener;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

@AjpIgnore
@RunWith(value=DefaultServer.class)
public class WebSocketServletTest {
    @Test
    public void testText() throws Exception {
        final AtomicBoolean connected = new AtomicBoolean(false);
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s1 = new ServletInfo("websocket", WebSocketServlet.class, (InstanceFactory)new ImmediateInstanceFactory((Object)new WebSocketServlet(new WebSocketConnectionCallback(){

            public void onConnect(final WebSocketHttpExchange exchange, WebSocketChannel channel) {
                connected.set(true);
                channel.getReceiveSetter().set((ChannelListener)new ChannelListener<WebSocketChannel>(){

                    public void handleEvent(final WebSocketChannel channel) {
                        try {
                            StreamSourceFrameChannel ws = channel.receive();
                            if (ws == null) {
                                return;
                            }
                            new StringReadChannelListener(exchange.getBufferPool()){

                                protected void stringDone(String string) {
                                    try {
                                        if (string.equals("hello")) {
                                            new StringWriteChannelListener("world").setup((StreamSinkChannel)channel.send(WebSocketFrameType.TEXT, (long)"world".length()));
                                        } else {
                                            new StringWriteChannelListener(string).setup((StreamSinkChannel)channel.send(WebSocketFrameType.TEXT, (long)string.length()));
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        throw new RuntimeException(e);
                                    }
                                }

                                protected void error(IOException e) {
                                    try {
                                        e.printStackTrace();
                                        new StringWriteChannelListener("ERROR").setup((StreamSinkChannel)channel.send(WebSocketFrameType.TEXT, (long)"ERROR".length()));
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                        throw new RuntimeException(ex);
                                    }
                                }
                            }.setup((StreamSourceChannel)ws);
                            channel.getReceiveSetter().set(null);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                channel.resumeReceives();
            }
        }))).addMapping("/*");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(ServletOutputStreamTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setResourceLoader(TestResourceLoader.NOOP_RESOURCE_LOADER).addServlets(new ServletInfo[]{s1});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        DefaultServer.setRootHandler((HttpHandler)manager.start());
        AtomicReference result = new AtomicReference();
        ConcreteIoFuture latch = new ConcreteIoFuture();
        WebSocketTestClient client = new WebSocketTestClient(WebSocketVersion.V13, new URI("ws://" + DefaultServer.getHostAddress((String)"default") + ":" + DefaultServer.getHostPort((String)"default") + "/"));
        client.connect();
        client.send((WebSocketFrame)new TextWebSocketFrame(ChannelBuffers.copiedBuffer((CharSequence)"hello", (Charset)CharsetUtil.US_ASCII)), (WebSocketTestClient.FrameListener)new FrameChecker(TextWebSocketFrame.class, "world".getBytes(CharsetUtil.US_ASCII), latch));
        latch.get();
        client.destroy();
    }
}

