/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.defaultservlet;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.test.path.ServletPathMappingTestCase;
import io.undertow.servlet.test.util.PathTestServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.test.util.TestResourceLoader;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletAndResourceWelcomeFileTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setClassLoader(ServletPathMappingTestCase.class.getClassLoader()).setContextPath("/servletContext").setDeploymentName("servletContext.war").setResourceManager((ResourceManager)new TestResourceLoader(ServletAndResourceWelcomeFileTestCase.class)).addWelcomePages(new String[]{"doesnotexist.html", "index.html", "default"});
        builder.addServlet(new ServletInfo("DefaultTestServlet", PathTestServlet.class).addMapping("*.html"));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWelcomeFileRedirect() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"pathInfo:null queryString:null servletPath:/index.html requestUri:/servletContext/index.html", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

