/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Headers;
import java.net.InetSocketAddress;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServletRequestContext {
    private static final ThreadLocal<ServletRequestContext> CURRENT = new ThreadLocal();
    public static final AttachmentKey<ServletRequestContext> ATTACHMENT_KEY = AttachmentKey.create(ServletRequestContext.class);
    private final Deployment deployment;
    private final HttpServletRequestImpl originalRequest;
    private final HttpServletResponseImpl originalResponse;
    private final ServletPathMatch originalServletPathMatch;
    private ServletResponse servletResponse;
    private ServletRequest servletRequest;
    private DispatcherType dispatcherType;
    private ServletChain currentServlet;
    private ServletPathMatch servletPathMatch;
    private List<SingleConstraintMatch> requiredConstrains;
    private TransportGuaranteeType transportGuarenteeType;
    private HttpSessionImpl session;
    private ServletContextImpl currentServetContext;

    public static void setCurrentRequestContext(ServletRequestContext servletRequestContext) {
        CURRENT.set(servletRequestContext);
    }

    public static void clearCurrentServletAttachments() {
        CURRENT.remove();
    }

    public static ServletRequestContext requireCurrent() {
        ServletRequestContext attachments = CURRENT.get();
        if (attachments == null) {
            throw UndertowMessages.MESSAGES.noRequestActive();
        }
        return attachments;
    }

    public static ServletRequestContext current() {
        return CURRENT.get();
    }

    public ServletRequestContext(Deployment deployment, HttpServletRequestImpl originalRequest, HttpServletResponseImpl originalResponse, ServletPathMatch originalServletPathMatch) {
        this.deployment = deployment;
        this.originalRequest = originalRequest;
        this.originalResponse = originalResponse;
        this.servletRequest = originalRequest;
        this.servletResponse = originalResponse;
        this.originalServletPathMatch = originalServletPathMatch;
        this.currentServetContext = deployment.getServletContext();
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public ServletChain getCurrentServlet() {
        return this.currentServlet;
    }

    public void setCurrentServlet(ServletChain currentServlet) {
        this.currentServlet = currentServlet;
    }

    public ServletPathMatch getServletPathMatch() {
        return this.servletPathMatch;
    }

    public void setServletPathMatch(ServletPathMatch servletPathMatch) {
        this.servletPathMatch = servletPathMatch;
    }

    public List<SingleConstraintMatch> getRequiredConstrains() {
        return this.requiredConstrains;
    }

    public void setRequiredConstrains(List<SingleConstraintMatch> requiredConstrains) {
        this.requiredConstrains = requiredConstrains;
    }

    public TransportGuaranteeType getTransportGuarenteeType() {
        return this.transportGuarenteeType;
    }

    public void setTransportGuarenteeType(TransportGuaranteeType transportGuarenteeType) {
        this.transportGuarenteeType = transportGuarenteeType;
    }

    public ServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public void setServletResponse(ServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    public ServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public void setServletRequest(ServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public HttpServletRequestImpl getOriginalRequest() {
        return this.originalRequest;
    }

    public HttpServletResponseImpl getOriginalResponse() {
        return this.originalResponse;
    }

    public HttpSessionImpl getSession() {
        return this.session;
    }

    public void setSession(HttpSessionImpl session) {
        this.session = session;
    }

    public HttpServerExchange getExchange() {
        return this.originalRequest.getExchange();
    }

    public ServletPathMatch getOriginalServletPathMatch() {
        return this.originalServletPathMatch;
    }

    public ServletContextImpl getCurrentServetContext() {
        return this.currentServetContext;
    }

    public void setCurrentServetContext(ServletContextImpl currentServetContext) {
        this.currentServetContext = currentServetContext;
    }

    public boolean displayStackTraces() {
        ServletStackTraces mode = this.deployment.getDeploymentInfo().getServletStackTraces();
        if (mode == ServletStackTraces.NONE) {
            return false;
        }
        if (mode == ServletStackTraces.ALL) {
            return true;
        }
        InetSocketAddress localAddress = this.getExchange().getSourceAddress();
        if (localAddress == null) {
            return false;
        }
        if (!localAddress.getAddress().isLoopbackAddress()) {
            return false;
        }
        return !this.getExchange().getRequestHeaders().contains(Headers.X_FORWARDED_FOR);
    }
}

