/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.constraint;

import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.DigestCredential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.util.HexConverter;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServletIdentityManager
implements IdentityManager {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Map<String, UserAccount> users = new HashMap<String, UserAccount>();

    public void addUser(String name, String password, String ... roles) {
        UserAccount user = new UserAccount();
        user.name = name;
        user.password = password.toCharArray();
        user.roles = new HashSet<String>(Arrays.asList(roles));
        this.users.put(name, user);
    }

    public Account verify(Account account) {
        return account;
    }

    public Account verify(String id, Credential credential) {
        Account account = this.users.get(id);
        if (account != null && this.verifyCredential(account, credential)) {
            return account;
        }
        return null;
    }

    public Account verify(Credential credential) {
        return null;
    }

    private boolean verifyCredential(Account account, Credential credential) {
        if (account instanceof UserAccount) {
            if (credential instanceof PasswordCredential) {
                char[] expectedPassword = ((UserAccount)account).password;
                char[] suppliedPassword = ((PasswordCredential)credential).getPassword();
                return Arrays.equals(expectedPassword, suppliedPassword);
            }
            if (credential instanceof DigestCredential) {
                DigestCredential digCred = (DigestCredential)credential;
                MessageDigest digest = null;
                try {
                    digest = digCred.getAlgorithm().getMessageDigest();
                    digest.update(account.getPrincipal().getName().getBytes(UTF_8));
                    digest.update((byte)58);
                    digest.update(digCred.getRealm().getBytes(UTF_8));
                    digest.update((byte)58);
                    char[] expectedPassword = ((UserAccount)account).password;
                    digest.update(new String(expectedPassword).getBytes(UTF_8));
                    boolean bl = digCred.verifyHA1(HexConverter.convertToHexBytes((byte[])digest.digest()));
                    return bl;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("Unsupported Algorithm", e);
                }
                finally {
                    digest.reset();
                }
            }
        }
        return false;
    }

    private static class UserAccount
    implements Account {
        String name;
        char[] password;
        Set<String> roles;
        private final Principal principal = new Principal(){

            @Override
            public String getName() {
                return UserAccount.this.name;
            }
        };

        private UserAccount() {
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public boolean isUserInRole(String role) {
            return this.roles.contains(role);
        }
    }
}

