/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.SessionPersistenceManager;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.session.SessionCookieConfigListener;
import io.undertow.servlet.test.session.SessionServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.servlet.util.InMemorySessionPersistence;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletSessionPersistenceTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleSessionUsage() throws IOException, ServletException {
        PathHandler pathHandler = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setSessionPersistenceManager((SessionPersistenceManager)new InMemorySessionPersistence()).addListener(new ListenerInfo(SessionCookieConfigListener.class)).addServlets(new ServletInfo[]{new ServletInfo("servlet", SessionServlet.class).addMapping("/aa")});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        try {
            pathHandler.addPath(builder.getContextPath(), manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        DefaultServer.setRootHandler((HttpHandler)pathHandler);
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/servletContext/aa");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"1", (Object)response);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"2", (Object)response);
            manager.stop();
            manager.undeploy();
            manager.deploy();
            pathHandler.addPath(builder.getContextPath(), manager.start());
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)"3", (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

