/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.core.ManagedListener;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;

public class ApplicationListeners
implements Lifecycle {
    private static final Class[] LISTENER_CLASSES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionListener.class, HttpSessionAttributeListener.class, HttpSessionIdListener.class};
    private static final ThreadLocal<ListenerState> IN_PROGRAMATIC_SC_LISTENER_INVOCATION = new ThreadLocal<ListenerState>(){

        @Override
        protected ListenerState initialValue() {
            return ListenerState.NO_LISTENER;
        }
    };
    private final ServletContext servletContext;
    private final List<ManagedListener> allListeners;
    private final List<ManagedListener> servletContextListeners;
    private final List<ManagedListener> servletContextAttributeListeners;
    private final List<ManagedListener> servletRequestListeners;
    private final List<ManagedListener> servletRequestAttributeListeners;
    private final List<ManagedListener> httpSessionListeners;
    private final List<ManagedListener> httpSessionAttributeListeners;
    private final List<ManagedListener> httpSessionIdListeners;
    private volatile boolean started = false;

    public ApplicationListeners(List<ManagedListener> allListeners, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.servletContextListeners = new CopyOnWriteArrayList<ManagedListener>();
        this.servletContextAttributeListeners = new CopyOnWriteArrayList<ManagedListener>();
        this.servletRequestListeners = new CopyOnWriteArrayList<ManagedListener>();
        this.servletRequestAttributeListeners = new CopyOnWriteArrayList<ManagedListener>();
        this.httpSessionListeners = new CopyOnWriteArrayList<ManagedListener>();
        this.httpSessionAttributeListeners = new CopyOnWriteArrayList<ManagedListener>();
        this.httpSessionIdListeners = new CopyOnWriteArrayList<ManagedListener>();
        this.allListeners = new CopyOnWriteArrayList<ManagedListener>();
        for (ManagedListener listener : allListeners) {
            this.addListener(listener);
        }
    }

    public void addListener(ManagedListener listener) {
        if (ServletContextListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            this.servletContextListeners.add(listener);
        }
        if (ServletContextAttributeListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            this.servletContextAttributeListeners.add(listener);
        }
        if (ServletRequestListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            this.servletRequestListeners.add(listener);
        }
        if (ServletRequestAttributeListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            this.servletRequestAttributeListeners.add(listener);
        }
        if (HttpSessionListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            this.httpSessionListeners.add(listener);
        }
        if (HttpSessionAttributeListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            this.httpSessionAttributeListeners.add(listener);
        }
        if (HttpSessionIdListener.class.isAssignableFrom(listener.getListenerInfo().getListenerClass())) {
            this.httpSessionIdListeners.add(listener);
        }
        this.allListeners.add(listener);
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        if (this.started) {
            this.started = false;
            for (ManagedListener listener : this.allListeners) {
                listener.stop();
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized() {
        ServletContextEvent event = new ServletContextEvent(this.servletContext);
        for (int i = 0; i < this.servletContextListeners.size(); ++i) {
            ManagedListener listener = this.servletContextListeners.get(i);
            IN_PROGRAMATIC_SC_LISTENER_INVOCATION.set(listener.isProgramatic() ? ListenerState.PROGRAMATIC_LISTENER : ListenerState.DECLARED_LISTENER);
            try {
                ((ServletContextListener)this.get(listener)).contextInitialized(event);
                continue;
            }
            finally {
                IN_PROGRAMATIC_SC_LISTENER_INVOCATION.remove();
            }
        }
    }

    public void contextDestroyed() {
        ServletContextEvent event = new ServletContextEvent(this.servletContext);
        ListIterator<ManagedListener> iterator = this.getReturningListIterator(this.servletContextListeners);
        while (iterator.hasPrevious()) {
            ManagedListener listener = iterator.previous();
            try {
                ((ServletContextListener)this.get(listener)).contextDestroyed(event);
            }
            catch (Exception e) {
                UndertowServletLogger.REQUEST_LOGGER.errorInvokingListener("contextDestroyed", listener.getListenerInfo().getListenerClass(), e);
            }
        }
    }

    public void servletContextAttributeAdded(String name, Object value) {
        ServletContextAttributeEvent sre = new ServletContextAttributeEvent(this.servletContext, name, value);
        for (ManagedListener listener : this.servletContextAttributeListeners) {
            ((ServletContextAttributeListener)this.get(listener)).attributeAdded(sre);
        }
    }

    public void servletContextAttributeRemoved(String name, Object value) {
        ServletContextAttributeEvent sre = new ServletContextAttributeEvent(this.servletContext, name, value);
        for (ManagedListener listener : this.servletContextAttributeListeners) {
            ((ServletContextAttributeListener)this.get(listener)).attributeRemoved(sre);
        }
    }

    public void servletContextAttributeReplaced(String name, Object value) {
        ServletContextAttributeEvent sre = new ServletContextAttributeEvent(this.servletContext, name, value);
        for (ManagedListener listener : this.servletContextAttributeListeners) {
            ((ServletContextAttributeListener)this.get(listener)).attributeReplaced(sre);
        }
    }

    public void requestInitialized(ServletRequest request) {
        ServletRequestEvent sre = new ServletRequestEvent(this.servletContext, request);
        for (ManagedListener listener : this.servletRequestListeners) {
            ((ServletRequestListener)this.get(listener)).requestInitialized(sre);
        }
    }

    public void requestDestroyed(ServletRequest request) {
        ServletRequestEvent sre = new ServletRequestEvent(this.servletContext, request);
        ListIterator<ManagedListener> iterator = this.getReturningListIterator(this.servletRequestListeners);
        while (iterator.hasPrevious()) {
            ManagedListener listener = iterator.previous();
            try {
                ((ServletRequestListener)this.get(listener)).requestDestroyed(sre);
            }
            catch (Exception e) {
                UndertowServletLogger.REQUEST_LOGGER.errorInvokingListener("requestDestroyed", listener.getListenerInfo().getListenerClass(), e);
            }
        }
    }

    public void servletRequestAttributeAdded(HttpServletRequest request, String name, Object value) {
        ServletRequestAttributeEvent sre = new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)request, name, value);
        for (ManagedListener listener : this.servletRequestAttributeListeners) {
            ((ServletRequestAttributeListener)this.get(listener)).attributeAdded(sre);
        }
    }

    public void servletRequestAttributeRemoved(HttpServletRequest request, String name, Object value) {
        ServletRequestAttributeEvent sre = new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)request, name, value);
        for (ManagedListener listener : this.servletRequestAttributeListeners) {
            ((ServletRequestAttributeListener)this.get(listener)).attributeRemoved(sre);
        }
    }

    public void servletRequestAttributeReplaced(HttpServletRequest request, String name, Object value) {
        ServletRequestAttributeEvent sre = new ServletRequestAttributeEvent(this.servletContext, (ServletRequest)request, name, value);
        for (ManagedListener listener : this.servletRequestAttributeListeners) {
            ((ServletRequestAttributeListener)this.get(listener)).attributeReplaced(sre);
        }
    }

    public void sessionCreated(HttpSession session) {
        HttpSessionEvent sre = new HttpSessionEvent(session);
        for (ManagedListener listener : this.httpSessionListeners) {
            ((HttpSessionListener)this.get(listener)).sessionCreated(sre);
        }
    }

    public void sessionDestroyed(HttpSession session) {
        HttpSessionEvent sre = new HttpSessionEvent(session);
        ListIterator<ManagedListener> iterator = this.getReturningListIterator(this.httpSessionListeners);
        while (iterator.hasPrevious()) {
            ManagedListener listener = iterator.previous();
            ((HttpSessionListener)this.get(listener)).sessionDestroyed(sre);
        }
    }

    public void httpSessionAttributeAdded(HttpSession session, String name, Object value) {
        HttpSessionBindingEvent sre = new HttpSessionBindingEvent(session, name, value);
        for (ManagedListener listener : this.httpSessionAttributeListeners) {
            ((HttpSessionAttributeListener)this.get(listener)).attributeAdded(sre);
        }
    }

    public void httpSessionAttributeRemoved(HttpSession session, String name, Object value) {
        HttpSessionBindingEvent sre = new HttpSessionBindingEvent(session, name, value);
        for (ManagedListener listener : this.httpSessionAttributeListeners) {
            ((HttpSessionAttributeListener)this.get(listener)).attributeRemoved(sre);
        }
    }

    public void httpSessionAttributeReplaced(HttpSession session, String name, Object value) {
        HttpSessionBindingEvent sre = new HttpSessionBindingEvent(session, name, value);
        for (ManagedListener listener : this.httpSessionAttributeListeners) {
            ((HttpSessionAttributeListener)this.get(listener)).attributeReplaced(sre);
        }
    }

    public void httpSessionIdChanged(HttpSession session, String oldSessionId) {
        HttpSessionEvent sre = new HttpSessionEvent(session);
        for (ManagedListener listener : this.httpSessionIdListeners) {
            ((HttpSessionIdListener)this.get(listener)).sessionIdChanged(sre, oldSessionId);
        }
    }

    private <T> T get(ManagedListener listener) {
        return (T)listener.instance();
    }

    private <T> ListIterator<T> getReturningListIterator(List<T> list) {
        return list.listIterator(list.size());
    }

    public static ListenerState listenerState() {
        return IN_PROGRAMATIC_SC_LISTENER_INVOCATION.get();
    }

    public static boolean isListenerClass(Class<?> clazz) {
        for (Class c : LISTENER_CLASSES) {
            if (!c.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static enum ListenerState {
        NO_LISTENER,
        DECLARED_LISTENER,
        PROGRAMATIC_LISTENER;

    }
}

