/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.constraint;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.constraint.AuthenticationMessageServlet;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import io.undertow.util.FlexBase64;
import io.undertow.util.Headers;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SecurityConstraintUrlMappingTestCase {
    public static final String HELLO_WORLD = "Hello World";

    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo s = new ServletInfo("servlet", AuthenticationMessageServlet.class).addInitParam("message", HELLO_WORLD).addMapping("/role1").addMapping("/role2").addMapping("/secured/role2/*").addMapping("/secured/1/2/*").addMapping("/public/*");
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", "role1");
        identityManager.addUser("user2", "password2", "role2");
        identityManager.addUser("user3", "password3", "role1", "role2");
        identityManager.addUser("user4", "password4", "badRole");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setIdentityManager((IdentityManager)identityManager).setLoginConfig(new LoginConfig("BASIC", "Test Realm")).addServlet(s);
        builder.addSecurityConstraint((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/role1")).addRoleAllowed("role1"));
        builder.addSecurityConstraint((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/secured/*")).addRoleAllowed("role2"));
        builder.addSecurityConstraint((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/secured/*")).addRoleAllowed("role2"));
        builder.addSecurityConstraint((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/secured/1/*")).addRoleAllowed("role1"));
        builder.addSecurityConstraint((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/secured/1/2/*")).addRoleAllowed("role2"));
        builder.addSecurityConstraint((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("*.html")).addRoleAllowed("role2"));
        builder.addSecurityConstraint((SecurityConstraint)new SecurityConstraint().addWebResourceCollection(new WebResourceCollection().addUrlPattern("/public/postSecured/*").addHttpMethod("POST")).addRoleAllowed("role1"));
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @Test
    public void testExactMatch() throws IOException {
        this.runSimpleUrlTest(DefaultServer.getDefaultServerURL() + "/servletContext/role1", "user2:password2", "user1:password1");
    }

    @Test
    public void testPatternMatch() throws IOException {
        this.runSimpleUrlTest(DefaultServer.getDefaultServerURL() + "/servletContext/secured/role2/aa", "user1:password1", "user2:password2");
    }

    @Test
    public void testExtensionMatch() throws IOException {
        this.runSimpleUrlTest(DefaultServer.getDefaultServerURL() + "/servletContext/public/a.html", "user1:password1", "user2:password2");
    }

    @Test
    public void testAggregatedRoles() throws IOException {
        this.runSimpleUrlTest(DefaultServer.getDefaultServerURL() + "/servletContext/secured/1/2/aa", "user4:password4", "user3:password3");
        this.runSimpleUrlTest(DefaultServer.getDefaultServerURL() + "/servletContext/secured/1/2/aa", "user4:password4", "user1:password1");
        this.runSimpleUrlTest(DefaultServer.getDefaultServerURL() + "/servletContext/secured/1/2/aa", "user4:password4", "user2:password2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpMethod() throws IOException {
        TestHttpClient client = new TestHttpClient();
        String url = DefaultServer.getDefaultServerURL() + "/servletContext/public/postSecured/a";
        try {
            HttpGet initialGet = new HttpGet(url);
            initialGet.addHeader("ExpectedMechanism", "None");
            initialGet.addHeader("ExpectedUser", "None");
            HttpResponse result = client.execute((HttpUriRequest)initialGet);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            HttpPost post = new HttpPost(url);
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
            Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)values[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            post = new HttpPost(url);
            post.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"user2:password2".getBytes(), (boolean)false));
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            post = new HttpPost(url);
            post.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])"user1:password1".getBytes(), (boolean)false));
            post.addHeader("ExpectedMechanism", "BASIC");
            post.addHeader("ExpectedUser", "user1");
            result = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)HELLO_WORLD, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSimpleUrlTest(String url, String badUser, String goodUser) throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            HttpGet get = new HttpGet(url);
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)401L, (long)result.getStatusLine().getStatusCode());
            Header[] values = result.getHeaders(Headers.WWW_AUTHENTICATE.toString());
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)(Headers.BASIC + " realm=\"Test Realm\""), (Object)values[0].getValue());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(url);
            get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])badUser.getBytes(), (boolean)false));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)403L, (long)result.getStatusLine().getStatusCode());
            HttpClientUtils.readResponse((HttpResponse)result);
            get = new HttpGet(url);
            get.addHeader(Headers.AUTHORIZATION.toString(), Headers.BASIC + " " + FlexBase64.encodeString((byte[])goodUser.getBytes(), (boolean)false));
            get.addHeader("ExpectedMechanism", "BASIC");
            get.addHeader("ExpectedUser", goodUser.substring(0, goodUser.indexOf(58)));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"0", (Object)result.getHeaders("Expires")[0].getValue());
            Assert.assertEquals((Object)"no-cache", (Object)result.getHeaders("Pragma")[0].getValue());
            Assert.assertEquals((Object)"no-cache, no-store, must-revalidate", (Object)result.getHeaders("Cache-Control")[0].getValue());
            String response = HttpClientUtils.readResponse((HttpResponse)result);
            Assert.assertEquals((Object)HELLO_WORLD, (Object)response);
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

