/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.form;

import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSecurityInfo;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.security.constraint.ServletIdentityManager;
import io.undertow.servlet.test.security.form.FormLoginServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import io.undertow.testutils.HttpClientUtils;
import io.undertow.testutils.TestHttpClient;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class SaveOriginalPostRequestTestCase {
    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler path = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        ServletInfo securedRequestDumper = new ServletInfo("SecuredRequestDumperServlet", RequestDumper.class).setServletSecurityInfo((ServletSecurityInfo)new ServletSecurityInfo().addRoleAllowed("role1")).addMapping("/secured/dumpRequest");
        ServletInfo unsecuredRequestDumper = new ServletInfo("UnsecuredRequestDumperServlet", RequestDumper.class).addMapping("/dumpRequest");
        ServletInfo loginFormServlet = new ServletInfo("loginPage", FormLoginServlet.class).setServletSecurityInfo((ServletSecurityInfo)new ServletSecurityInfo().addRoleAllowed("group1")).addMapping("/FormLoginServlet");
        ServletIdentityManager identityManager = new ServletIdentityManager();
        identityManager.addUser("user1", "password1", "role1");
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").setIdentityManager((IdentityManager)identityManager).setLoginConfig(new LoginConfig("FORM", "Test Realm", "/FormLoginServlet", "/error.html")).addServlets(new ServletInfo[]{securedRequestDumper, unsecuredRequestDumper, loginFormServlet});
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        path.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)path);
    }

    @Test
    public void testParametersFromOriginalPostRequest() throws IOException {
        TestHttpClient client = this.createHttpClient();
        HttpResponse result = this.executePostRequest(client, "/servletContext/dumpRequest", new BasicNameValuePair("param1", "param1Value"), new BasicNameValuePair("param2", "param2Value"));
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        String response = HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertTrue((boolean)response.contains("param1=param1Value/param2=param2Value"));
        result = this.executePostRequest(client, "/servletContext/secured/dumpRequest", new BasicNameValuePair("securedParam1", "securedParam1Value"), new BasicNameValuePair("securedParam2", "securedParam2Value"));
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"Login Page", (Object)HttpClientUtils.readResponse((HttpResponse)result));
        result = this.executePostRequest(client, "/servletContext/j_security_check", new BasicNameValuePair("j_username", "user1"), new BasicNameValuePair("j_password", "password1"));
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
        response = HttpClientUtils.readResponse((HttpResponse)result);
        Assert.assertTrue((boolean)response.contains("securedParam1=securedParam1Value"));
        Assert.assertTrue((boolean)response.contains("securedParam2=securedParam2Value"));
    }

    private TestHttpClient createHttpClient() {
        TestHttpClient client = new TestHttpClient();
        client.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                if (response.getStatusLine().getStatusCode() == 302) {
                    return true;
                }
                return super.isRedirected(request, response, context);
            }
        });
        return client;
    }

    private HttpResponse executePostRequest(TestHttpClient client, String uri, BasicNameValuePair ... parameters) throws IOException {
        HttpPost request = new HttpPost(DefaultServer.getDefaultServerURL() + uri);
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(new ArrayList<BasicNameValuePair>(Arrays.asList(parameters))));
        return client.execute((HttpUriRequest)request);
    }

    static class RequestDumper
    extends HttpServlet {
        RequestDumper() {
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.dumpRequest(req, resp);
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.dumpRequest(req, resp);
        }

        private void dumpRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            StringBuilder buffer = new StringBuilder();
            PrintWriter writer = resp.getWriter();
            buffer.append("Method: " + req.getMethod() + "\n");
            Enumeration parameterNames = req.getParameterNames();
            buffer.append("Parameters: ");
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                buffer.append(parameterName + "=" + req.getParameter(parameterName));
                buffer.append("/");
            }
            writer.write(buffer.toString());
        }
    }
}

