/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.listener.servletcontext;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.test.SimpleServletTestCase;
import io.undertow.servlet.test.listener.servletcontext.ServletContextTestListener;
import io.undertow.servlet.test.util.MessageServlet;
import io.undertow.servlet.test.util.TestClassIntrospector;
import io.undertow.testutils.DefaultServer;
import java.io.IOException;
import javax.servlet.ServletException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class ServletContextListenerTestCase {
    static DeploymentManager manager;

    @BeforeClass
    public static void setup() throws ServletException {
        PathHandler root = new PathHandler();
        ServletContainer container = ServletContainer.Factory.newInstance();
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(SimpleServletTestCase.class.getClassLoader()).setContextPath("/servletContext").setClassIntrospecter((ClassIntrospecter)TestClassIntrospector.INSTANCE).setDeploymentName("servletContext.war").addServlet(new ServletInfo("servlet", MessageServlet.class).addMapping("/aa")).addListener(new ListenerInfo(ServletContextTestListener.class));
        manager = container.addDeployment(builder);
        manager.deploy();
        root.addPrefixPath(builder.getContextPath(), manager.start());
        DefaultServer.setRootHandler((HttpHandler)root);
    }

    @Test
    public void testServletContextInitialized() throws IOException {
        Assert.assertNotNull((Object)ServletContextTestListener.servletContextInitializedEvent);
    }

    @Test
    public void testServletContextAttributeListener() throws IOException {
        ServletContextImpl sc = manager.getDeployment().getServletContext();
        sc.setAttribute("test", (Object)"1");
        Assert.assertNotNull((Object)ServletContextTestListener.servletContextAttributeEvent);
        Assert.assertEquals((Object)ServletContextTestListener.servletContextAttributeEvent.getName(), (Object)"test");
        Assert.assertEquals((Object)ServletContextTestListener.servletContextAttributeEvent.getValue(), (Object)"1");
        sc.setAttribute("test", (Object)"2");
        Assert.assertEquals((Object)ServletContextTestListener.servletContextAttributeEvent.getName(), (Object)"test");
        Assert.assertEquals((Object)ServletContextTestListener.servletContextAttributeEvent.getValue(), (Object)"1");
        sc.setAttribute("test", (Object)"3");
        Assert.assertEquals((Object)ServletContextTestListener.servletContextAttributeEvent.getName(), (Object)"test");
        Assert.assertEquals((Object)ServletContextTestListener.servletContextAttributeEvent.getValue(), (Object)"2");
        sc.removeAttribute("test");
        Assert.assertEquals((Object)ServletContextTestListener.servletContextAttributeEvent.getName(), (Object)"test");
        Assert.assertEquals((Object)ServletContextTestListener.servletContextAttributeEvent.getValue(), (Object)"3");
    }
}

