/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.test.security.constraint;

import io.undertow.servlet.test.util.MessageServlet;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationMessageServlet
extends MessageServlet {
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.checkExpectedMechanism(req);
        this.checkExpectedUser(req);
        super.doGet(req, resp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void checkExpectedMechanism(HttpServletRequest req) {
        String expectedMechanism = req.getHeader("ExpectedMechanism");
        if (expectedMechanism == null) {
            throw new IllegalStateException("No ExpectedMechanism received.");
        }
        if (expectedMechanism.equals("None")) {
            if (req.getAuthType() != null) {
                throw new IllegalStateException("Authentication occurred when not expected.");
            }
        } else if (expectedMechanism.equals("BASIC")) {
            if (req.getAuthType() != "BASIC") {
                throw new IllegalStateException("Expected mechanism type not matched.");
            }
        } else {
            throw new IllegalStateException("ExpectedMechanism not recognised.");
        }
    }

    private void checkExpectedUser(HttpServletRequest req) {
        String expectedUser = req.getHeader("ExpectedUser");
        if (expectedUser == null) {
            throw new IllegalStateException("No ExpectedUser received.");
        }
        if (expectedUser.equals("None")) {
            if (req.getRemoteUser() != null) {
                throw new IllegalStateException("Unexpected RemoteUser returned.");
            }
            if (req.getUserPrincipal() != null) {
                throw new IllegalStateException("Unexpected UserPrincipal returned.");
            }
        } else {
            if (!req.getRemoteUser().equals(expectedUser)) {
                throw new IllegalStateException("Different RemoteUser returned.");
            }
            if (!req.getUserPrincipal().getName().equals(expectedUser)) {
                throw new IllegalStateException("Different UserPrincipal returned.");
            }
        }
    }
}

